/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.opensearch.builder.batch;

import com.aliyun.opensearch.DocumentClient;
import com.aliyun.opensearch.sdk.dependencies.org.json.JSONArray;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchClientException;
import com.aliyun.opensearch.sdk.generated.commons.OpenSearchException;
import com.ohaotian.plugin.es.builder.batch.BatchInsertRequestBuilder;
import com.ohaotian.plugin.es.opensearch.OpenSearchClient;
import com.ohaotian.plugin.es.opensearch.builder.insert.OsInsertRequestBuilder;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OsBatchInsertRequestBuilder
implements BatchInsertRequestBuilder<OsInsertRequestBuilder.OsInsertBuilderItem> {
    private final Logger logger = LogManager.getLogger(OsBatchInsertRequestBuilder.class);
    @Autowired
    private OpenSearchClient client;

    @Override
    public void bulk(Collection<OsInsertRequestBuilder.OsInsertBuilderItem> builders) {
        DocumentClient documentClient = this.client.createDocumentClient();
        JSONArray rows = new JSONArray();
        String tableName = "";
        for (OsInsertRequestBuilder.OsInsertBuilderItem builderItem : builders) {
            for (int i = 0; i < builderItem.getRows().length(); ++i) {
                rows.put(builderItem.getRows().get(i));
                tableName = builderItem.getTableName();
            }
        }
        try {
            documentClient.push(rows.toString(), tableName, tableName);
        }
        catch (OpenSearchClientException | OpenSearchException e) {
            this.logger.error(e.getMessage(), e);
        }
    }
}

