/*
 * Decompiled with CFR 0.152.
 */
package com.ohaotian.plugin.es.opensearch.builder.search;

import com.ohaotian.plugin.es.builder.search.filter.BooleanFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.FilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.MatchFilterCondition;
import com.ohaotian.plugin.es.builder.search.filter.RangeFilterCondition;

public enum OpenSearchFilterBuilder {
    INSTANCE;


    public String build(FilterCondition condition) {
        if (condition instanceof MatchFilterCondition) {
            MatchFilterCondition matchCondition = (MatchFilterCondition)condition;
            return matchCondition.getColumnName() + "=" + matchCondition.getValue();
        }
        if (condition instanceof BooleanFilterCondition) {
            BooleanFilterCondition booleanCondition = (BooleanFilterCondition)condition;
            StringBuilder boolConditionStr = new StringBuilder();
            boolConditionStr.append("(");
            if (booleanCondition.getMust().size() > 0) {
                boolConditionStr.append("(");
                boolean firstMust = true;
                for (FilterCondition filterCondition : booleanCondition.getMust()) {
                    if (!firstMust) {
                        boolConditionStr.append(" AND ");
                    }
                    boolConditionStr.append(this.build(filterCondition));
                    firstMust = false;
                }
                boolConditionStr.append(")");
            }
            if (booleanCondition.getShould().size() > 0) {
                if (booleanCondition.getMust().size() > 0) {
                    boolConditionStr.append(" OR ");
                }
                boolConditionStr.append("(");
                boolean firstShould = true;
                for (FilterCondition filterCondition : booleanCondition.getShould()) {
                    if (!firstShould) {
                        boolConditionStr.append(" OR ");
                    }
                    boolConditionStr.append(this.build(filterCondition));
                    firstShould = false;
                }
                boolConditionStr.append(")");
            }
            boolConditionStr.append(")");
            return boolConditionStr.toString();
        }
        if (condition instanceof RangeFilterCondition) {
            RangeFilterCondition rangeCondition = (RangeFilterCondition)condition;
            StringBuilder rangeConditionStr = new StringBuilder();
            if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.GT)) {
                rangeConditionStr.append(rangeCondition.getColumnName() + ">" + rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.GTE)) {
                rangeConditionStr.append(rangeCondition.getColumnName() + ">=" + rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.LT)) {
                rangeConditionStr.append(rangeCondition.getColumnName() + "<" + rangeCondition.getValue());
            } else if (rangeCondition.getOperator().equals((Object)RangeFilterCondition.Operator.LTE)) {
                rangeConditionStr.append(rangeCondition.getColumnName() + "<=" + rangeCondition.getValue());
            }
            return rangeConditionStr.toString();
        }
        throw new RuntimeException("\u7406\u8bba\u4e0a\u4e0d\u5e94\u8be5\u554a" + condition.getClass().getName());
    }
}

