package com.ohaotian.plugin.validation.constraints;

import com.ohaotian.plugin.validation.internal.constraintvalidators.StartsWithValidator;

import javax.validation.Constraint;
import javax.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.*;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * 输入的内容必须以"{0}"作为起始字符
 *
 * @author TheWk
 * @version 1.0.0
 * <pre>
 * =========================== Logs =========================== <br>
 * 1.0.0(2018-03-07 17:00) TheWk 创建 <br>
 * =========================== Logs =========================== <br>
 * </pre>
 */
@Retention(RUNTIME)
@Documented
@Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
@Constraint(validatedBy = {StartsWithValidator.class})
public @interface StartsWith {

    String value();

    String message() default "{cn.thewk.starter.validation.constraints.StartsWith.message}";

    Class<?>[] groups() default {};

    Class<? extends Payload>[] payload() default {};

    /**
     * Defines several {@link StartsWith} annotations on the same element.
     *
     * @see StartsWith
     */
    @Target({METHOD, FIELD, ANNOTATION_TYPE, CONSTRUCTOR, PARAMETER})
    @Retention(RUNTIME)
    @Documented
    @interface List {

        StartsWith[] value();
    }
}
