/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for GetRefundInput type.
 */
public class GetRefundInput {
    private String refundId;
    private String paypalMockResponse;
    private String paypalAuthAssertion;

    /**
     * Default constructor.
     */
    public GetRefundInput() {
    }

    /**
     * Initialization constructor.
     * @param  refundId  String value for refundId.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     */
    public GetRefundInput(
            String refundId,
            String paypalMockResponse,
            String paypalAuthAssertion) {
        this.refundId = refundId;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for RefundId.
     * The PayPal-generated ID for the refund for which to show details.
     * @return Returns the String
     */
    @JsonGetter("refund_id")
    public String getRefundId() {
        return refundId;
    }

    /**
     * Setter for RefundId.
     * The PayPal-generated ID for the refund for which to show details.
     * @param refundId Value for String
     */
    @JsonSetter("refund_id")
    public void setRefundId(String refundId) {
        this.refundId = refundId;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see
     * [PayPal-Auth-Assertion](/docs/api/reference/api-requests/#paypal-auth-assertion). Note:For
     * three party transactions in which a partner is managing the API calls on behalf of a
     * merchant, the partner must identify the merchant using either a PayPal-Auth-Assertion header
     * or an access token with target_subject.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Converts this GetRefundInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "GetRefundInput [" + "refundId=" + refundId + ", paypalMockResponse="
                + paypalMockResponse + ", paypalAuthAssertion=" + paypalAuthAssertion + "]";
    }

    /**
     * Builds a new {@link GetRefundInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link GetRefundInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(refundId)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalAuthAssertion(getPaypalAuthAssertion());
        return builder;
    }

    /**
     * Class to build instances of {@link GetRefundInput}.
     */
    public static class Builder {
        private String refundId;
        private String paypalMockResponse;
        private String paypalAuthAssertion;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  refundId  String value for refundId.
         */
        public Builder(String refundId) {
            this.refundId = refundId;
        }

        /**
         * Setter for refundId.
         * @param  refundId  String value for refundId.
         * @return Builder
         */
        public Builder refundId(String refundId) {
            this.refundId = refundId;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Builds a new {@link GetRefundInput} object using the set fields.
         * @return {@link GetRefundInput}
         */
        public GetRefundInput build() {
            return new GetRefundInput(refundId, paypalMockResponse, paypalAuthAssertion);
        }
    }
}
