/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for Item type.
 */
public class Item {
    private String name;
    private Money unitAmount;
    private Money tax;
    private String quantity;
    private String description;
    private String sku;
    private String url;
    private ItemCategory category;
    private String imageUrl;
    private UniversalProductCode upc;

    /**
     * Default constructor.
     */
    public Item() {
    }

    /**
     * Initialization constructor.
     * @param  name  String value for name.
     * @param  unitAmount  Money value for unitAmount.
     * @param  quantity  String value for quantity.
     * @param  tax  Money value for tax.
     * @param  description  String value for description.
     * @param  sku  String value for sku.
     * @param  url  String value for url.
     * @param  category  ItemCategory value for category.
     * @param  imageUrl  String value for imageUrl.
     * @param  upc  UniversalProductCode value for upc.
     */
    public Item(
            String name,
            Money unitAmount,
            String quantity,
            Money tax,
            String description,
            String sku,
            String url,
            ItemCategory category,
            String imageUrl,
            UniversalProductCode upc) {
        this.name = name;
        this.unitAmount = unitAmount;
        this.tax = tax;
        this.quantity = quantity;
        this.description = description;
        this.sku = sku;
        this.url = url;
        this.category = category;
        this.imageUrl = imageUrl;
        this.upc = upc;
    }

    /**
     * Getter for Name.
     * The item name or title.
     * @return Returns the String
     */
    @JsonGetter("name")
    public String getName() {
        return name;
    }

    /**
     * Setter for Name.
     * The item name or title.
     * @param name Value for String
     */
    @JsonSetter("name")
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Getter for UnitAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("unit_amount")
    public Money getUnitAmount() {
        return unitAmount;
    }

    /**
     * Setter for UnitAmount.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param unitAmount Value for Money
     */
    @JsonSetter("unit_amount")
    public void setUnitAmount(Money unitAmount) {
        this.unitAmount = unitAmount;
    }

    /**
     * Getter for Tax.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @return Returns the Money
     */
    @JsonGetter("tax")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Money getTax() {
        return tax;
    }

    /**
     * Setter for Tax.
     * The currency and amount for a financial transaction, such as a balance or payment due.
     * @param tax Value for Money
     */
    @JsonSetter("tax")
    public void setTax(Money tax) {
        this.tax = tax;
    }

    /**
     * Getter for Quantity.
     * The item quantity. Must be a whole number.
     * @return Returns the String
     */
    @JsonGetter("quantity")
    public String getQuantity() {
        return quantity;
    }

    /**
     * Setter for Quantity.
     * The item quantity. Must be a whole number.
     * @param quantity Value for String
     */
    @JsonSetter("quantity")
    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    /**
     * Getter for Description.
     * The detailed item description.
     * @return Returns the String
     */
    @JsonGetter("description")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return description;
    }

    /**
     * Setter for Description.
     * The detailed item description.
     * @param description Value for String
     */
    @JsonSetter("description")
    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * Getter for Sku.
     * The stock keeping unit (SKU) for the item.
     * @return Returns the String
     */
    @JsonGetter("sku")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getSku() {
        return sku;
    }

    /**
     * Setter for Sku.
     * The stock keeping unit (SKU) for the item.
     * @param sku Value for String
     */
    @JsonSetter("sku")
    public void setSku(String sku) {
        this.sku = sku;
    }

    /**
     * Getter for Url.
     * The URL to the item being purchased. Visible to buyer and used in buyer experiences.
     * @return Returns the String
     */
    @JsonGetter("url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getUrl() {
        return url;
    }

    /**
     * Setter for Url.
     * The URL to the item being purchased. Visible to buyer and used in buyer experiences.
     * @param url Value for String
     */
    @JsonSetter("url")
    public void setUrl(String url) {
        this.url = url;
    }

    /**
     * Getter for Category.
     * The item category type.
     * @return Returns the ItemCategory
     */
    @JsonGetter("category")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ItemCategory getCategory() {
        return category;
    }

    /**
     * Setter for Category.
     * The item category type.
     * @param category Value for ItemCategory
     */
    @JsonSetter("category")
    public void setCategory(ItemCategory category) {
        this.category = category;
    }

    /**
     * Getter for ImageUrl.
     * The URL of the item's image. File type and size restrictions apply. An image that violates
     * these restrictions will not be honored.
     * @return Returns the String
     */
    @JsonGetter("image_url")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getImageUrl() {
        return imageUrl;
    }

    /**
     * Setter for ImageUrl.
     * The URL of the item's image. File type and size restrictions apply. An image that violates
     * these restrictions will not be honored.
     * @param imageUrl Value for String
     */
    @JsonSetter("image_url")
    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    /**
     * Getter for Upc.
     * The Universal Product Code of the item.
     * @return Returns the UniversalProductCode
     */
    @JsonGetter("upc")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public UniversalProductCode getUpc() {
        return upc;
    }

    /**
     * Setter for Upc.
     * The Universal Product Code of the item.
     * @param upc Value for UniversalProductCode
     */
    @JsonSetter("upc")
    public void setUpc(UniversalProductCode upc) {
        this.upc = upc;
    }

    /**
     * Converts this Item into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "Item [" + "name=" + name + ", unitAmount=" + unitAmount + ", quantity=" + quantity
                + ", tax=" + tax + ", description=" + description + ", sku=" + sku + ", url=" + url
                + ", category=" + category + ", imageUrl=" + imageUrl + ", upc=" + upc + "]";
    }

    /**
     * Builds a new {@link Item.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link Item.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(name, unitAmount, quantity)
                .tax(getTax())
                .description(getDescription())
                .sku(getSku())
                .url(getUrl())
                .category(getCategory())
                .imageUrl(getImageUrl())
                .upc(getUpc());
        return builder;
    }

    /**
     * Class to build instances of {@link Item}.
     */
    public static class Builder {
        private String name;
        private Money unitAmount;
        private String quantity;
        private Money tax;
        private String description;
        private String sku;
        private String url;
        private ItemCategory category;
        private String imageUrl;
        private UniversalProductCode upc;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  name  String value for name.
         * @param  unitAmount  Money value for unitAmount.
         * @param  quantity  String value for quantity.
         */
        public Builder(String name, Money unitAmount, String quantity) {
            this.name = name;
            this.unitAmount = unitAmount;
            this.quantity = quantity;
        }

        /**
         * Setter for name.
         * @param  name  String value for name.
         * @return Builder
         */
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        /**
         * Setter for unitAmount.
         * @param  unitAmount  Money value for unitAmount.
         * @return Builder
         */
        public Builder unitAmount(Money unitAmount) {
            this.unitAmount = unitAmount;
            return this;
        }

        /**
         * Setter for quantity.
         * @param  quantity  String value for quantity.
         * @return Builder
         */
        public Builder quantity(String quantity) {
            this.quantity = quantity;
            return this;
        }

        /**
         * Setter for tax.
         * @param  tax  Money value for tax.
         * @return Builder
         */
        public Builder tax(Money tax) {
            this.tax = tax;
            return this;
        }

        /**
         * Setter for description.
         * @param  description  String value for description.
         * @return Builder
         */
        public Builder description(String description) {
            this.description = description;
            return this;
        }

        /**
         * Setter for sku.
         * @param  sku  String value for sku.
         * @return Builder
         */
        public Builder sku(String sku) {
            this.sku = sku;
            return this;
        }

        /**
         * Setter for url.
         * @param  url  String value for url.
         * @return Builder
         */
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        /**
         * Setter for category.
         * @param  category  ItemCategory value for category.
         * @return Builder
         */
        public Builder category(ItemCategory category) {
            this.category = category;
            return this;
        }

        /**
         * Setter for imageUrl.
         * @param  imageUrl  String value for imageUrl.
         * @return Builder
         */
        public Builder imageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        /**
         * Setter for upc.
         * @param  upc  UniversalProductCode value for upc.
         * @return Builder
         */
        public Builder upc(UniversalProductCode upc) {
            this.upc = upc;
            return this;
        }

        /**
         * Builds a new {@link Item} object using the set fields.
         * @return {@link Item}
         */
        public Item build() {
            return new Item(name, unitAmount, quantity, tax, description, sku, url, category,
                    imageUrl, upc);
        }
    }
}
