/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for PatchOrderInput type.
 */
public class PatchOrderInput {
    private String id;
    private String contentType;
    private String paypalMockResponse;
    private String paypalAuthAssertion;
    private List<Patch> body;

    /**
     * Default constructor.
     */
    public PatchOrderInput() {
        contentType = "application/json";
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  contentType  String value for contentType.
     * @param  paypalMockResponse  String value for paypalMockResponse.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  body  List of Patch value for body.
     */
    public PatchOrderInput(
            String id,
            String contentType,
            String paypalMockResponse,
            String paypalAuthAssertion,
            List<Patch> body) {
        this.id = id;
        this.contentType = contentType;
        this.paypalMockResponse = paypalMockResponse;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    /**
     * Getter for Id.
     * The ID of the order to update.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order to update.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Mock-Response")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalMockResponse() {
        return paypalMockResponse;
    }

    /**
     * Setter for PaypalMockResponse.
     * PayPal's REST API uses a request header to invoke negative testing in the sandbox. This
     * header configures the sandbox into a negative testing state for transactions that include the
     * merchant.
     * @param paypalMockResponse Value for String
     */
    @JsonSetter("PayPal-Mock-Response")
    public void setPaypalMockResponse(String paypalMockResponse) {
        this.paypalMockResponse = paypalMockResponse;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Body.
     * @return Returns the List of Patch
     */
    @JsonGetter("body")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<Patch> getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for List of Patch
     */
    @JsonSetter("body")
    public void setBody(List<Patch> body) {
        this.body = body;
    }

    /**
     * Converts this PatchOrderInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PatchOrderInput [" + "id=" + id + ", contentType=" + contentType
                + ", paypalMockResponse=" + paypalMockResponse + ", paypalAuthAssertion="
                + paypalAuthAssertion + ", body=" + body + "]";
    }

    /**
     * Builds a new {@link PatchOrderInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PatchOrderInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, contentType)
                .paypalMockResponse(getPaypalMockResponse())
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .body(getBody());
        return builder;
    }

    /**
     * Class to build instances of {@link PatchOrderInput}.
     */
    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private String paypalMockResponse;
        private String paypalAuthAssertion;
        private List<Patch> body;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  contentType  String value for contentType.
         */
        public Builder(String id, String contentType) {
            this.id = id;
            this.contentType = contentType;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for paypalMockResponse.
         * @param  paypalMockResponse  String value for paypalMockResponse.
         * @return Builder
         */
        public Builder paypalMockResponse(String paypalMockResponse) {
            this.paypalMockResponse = paypalMockResponse;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  List of Patch value for body.
         * @return Builder
         */
        public Builder body(List<Patch> body) {
            this.body = body;
            return this;
        }

        /**
         * Builds a new {@link PatchOrderInput} object using the set fields.
         * @return {@link PatchOrderInput}
         */
        public PatchOrderInput build() {
            return new PatchOrderInput(id, contentType, paypalMockResponse, paypalAuthAssertion,
                    body);
        }
    }
}
