/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;


/**
 * StoredPaymentSourcePaymentType to be used.
 */
public enum StoredPaymentSourcePaymentType {
    /**
     * One Time payment such as online purchase or donation. (e.g. Checkout with one-click).
     */
    ONE_TIME,

    /**
     * Payment which is part of a series of payments with fixed or variable amounts, following a fixed time interval. (e.g. Subscription payments).
     */
    RECURRING,

    /**
     * Payment which is part of a series of payments that occur on a non-fixed schedule and/or have variable amounts. (e.g. Account Topup payments).
     */
    UNSCHEDULED,

    /**
     * Unknown values will be mapped by this enum member
     */
    _UNKNOWN;


    private static TreeMap<String, StoredPaymentSourcePaymentType> valueMap = new TreeMap<>();
    private String value;

    static {
        ONE_TIME.value = "ONE_TIME";
        RECURRING.value = "RECURRING";
        UNSCHEDULED.value = "UNSCHEDULED";
        _UNKNOWN.value = null;

        valueMap.put("ONE_TIME", ONE_TIME);
        valueMap.put("RECURRING", RECURRING);
        valueMap.put("UNSCHEDULED", UNSCHEDULED);
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     * @throws IOException when provided value is not mapped to any enum member.
     */
    @JsonCreator
    public static StoredPaymentSourcePaymentType constructFromString(String toConvert) throws IOException {
        StoredPaymentSourcePaymentType enumValue = fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    /**
     * Returns the enum member associated with the given string value.
     * @param toConvert String value to get enum member.
     * @return The enum member against the given string value.
     */
    public static StoredPaymentSourcePaymentType fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    /**
     * Returns the string value associated with the enum member.
     * @return The string value against enum member.
     */
    @JsonValue
    public String value() {
        return value;
    }
        
    /**
     * Get string representation of this enum.
     */
    @Override
    public String toString() {
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /**
     * Convert list of StoredPaymentSourcePaymentType values to list of string values.
     * @param toConvert The list of StoredPaymentSourcePaymentType values to convert.
     * @return List of representative string values.
     */
    public static List<String> toValue(List<StoredPaymentSourcePaymentType> toConvert) {
        if (toConvert == null) {
            return null;
        }
        List<String> convertedValues = new ArrayList<>();
        for (StoredPaymentSourcePaymentType enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }
} 