/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum Environment {
    PRODUCTION,
    SANDBOX;

    private static TreeMap<String, Environment> valueMap;
    private String value;

    @JsonCreator
    public static Environment constructFromString(String toConvert) throws IOException {
        Environment enumValue = Environment.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static Environment fromString(String toConvert) {
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        return this.value.toString();
    }

    public static List<String> toValue(List<Environment> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (Environment enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        Environment.PRODUCTION.value = "Production";
        Environment.SANDBOX.value = "Sandbox";
        valueMap.put("Production", PRODUCTION);
        valueMap.put("Sandbox", SANDBOX);
    }
}

