/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.NetworkTransactionReference;
import com.paypal.sdk.models.PaymentInitiator;
import com.paypal.sdk.models.StoredPaymentSourcePaymentType;
import com.paypal.sdk.models.StoredPaymentSourceUsageType;

public class CardStoredCredential {
    private PaymentInitiator paymentInitiator;
    private StoredPaymentSourcePaymentType paymentType;
    private StoredPaymentSourceUsageType usage;
    private NetworkTransactionReference previousNetworkTransactionReference;

    public CardStoredCredential() {
        this.usage = StoredPaymentSourceUsageType.DERIVED;
    }

    public CardStoredCredential(PaymentInitiator paymentInitiator, StoredPaymentSourcePaymentType paymentType, StoredPaymentSourceUsageType usage, NetworkTransactionReference previousNetworkTransactionReference) {
        this.paymentInitiator = paymentInitiator;
        this.paymentType = paymentType;
        this.usage = usage;
        this.previousNetworkTransactionReference = previousNetworkTransactionReference;
    }

    @JsonGetter(value="payment_initiator")
    public PaymentInitiator getPaymentInitiator() {
        return this.paymentInitiator;
    }

    @JsonSetter(value="payment_initiator")
    public void setPaymentInitiator(PaymentInitiator paymentInitiator) {
        this.paymentInitiator = paymentInitiator;
    }

    @JsonGetter(value="payment_type")
    public StoredPaymentSourcePaymentType getPaymentType() {
        return this.paymentType;
    }

    @JsonSetter(value="payment_type")
    public void setPaymentType(StoredPaymentSourcePaymentType paymentType) {
        this.paymentType = paymentType;
    }

    @JsonGetter(value="usage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public StoredPaymentSourceUsageType getUsage() {
        return this.usage;
    }

    @JsonSetter(value="usage")
    public void setUsage(StoredPaymentSourceUsageType usage) {
        this.usage = usage;
    }

    @JsonGetter(value="previous_network_transaction_reference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NetworkTransactionReference getPreviousNetworkTransactionReference() {
        return this.previousNetworkTransactionReference;
    }

    @JsonSetter(value="previous_network_transaction_reference")
    public void setPreviousNetworkTransactionReference(NetworkTransactionReference previousNetworkTransactionReference) {
        this.previousNetworkTransactionReference = previousNetworkTransactionReference;
    }

    public String toString() {
        return "CardStoredCredential [paymentInitiator=" + (Object)((Object)this.paymentInitiator) + ", paymentType=" + (Object)((Object)this.paymentType) + ", usage=" + (Object)((Object)this.usage) + ", previousNetworkTransactionReference=" + this.previousNetworkTransactionReference + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.paymentInitiator, this.paymentType).usage(this.getUsage()).previousNetworkTransactionReference(this.getPreviousNetworkTransactionReference());
        return builder;
    }

    public static class Builder {
        private PaymentInitiator paymentInitiator;
        private StoredPaymentSourcePaymentType paymentType;
        private StoredPaymentSourceUsageType usage = StoredPaymentSourceUsageType.DERIVED;
        private NetworkTransactionReference previousNetworkTransactionReference;

        public Builder() {
        }

        public Builder(PaymentInitiator paymentInitiator, StoredPaymentSourcePaymentType paymentType) {
            this.paymentInitiator = paymentInitiator;
            this.paymentType = paymentType;
        }

        public Builder paymentInitiator(PaymentInitiator paymentInitiator) {
            this.paymentInitiator = paymentInitiator;
            return this;
        }

        public Builder paymentType(StoredPaymentSourcePaymentType paymentType) {
            this.paymentType = paymentType;
            return this;
        }

        public Builder usage(StoredPaymentSourceUsageType usage) {
            this.usage = usage;
            return this;
        }

        public Builder previousNetworkTransactionReference(NetworkTransactionReference previousNetworkTransactionReference) {
            this.previousNetworkTransactionReference = previousNetworkTransactionReference;
            return this;
        }

        public CardStoredCredential build() {
            return new CardStoredCredential(this.paymentInitiator, this.paymentType, this.usage, this.previousNetworkTransactionReference);
        }
    }
}

