/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.OrderTrackerRequest;

public class CreateOrderTrackingInput {
    private String id;
    private String contentType;
    private OrderTrackerRequest body;
    private String paypalAuthAssertion;

    public CreateOrderTrackingInput() {
        this.contentType = "application/json";
    }

    public CreateOrderTrackingInput(String id, String contentType, OrderTrackerRequest body, String paypalAuthAssertion) {
        this.id = id;
        this.contentType = contentType;
        this.body = body;
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    @JsonGetter(value="id")
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="Content-Type")
    public String getContentType() {
        return this.contentType;
    }

    @JsonSetter(value="Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @JsonGetter(value="body")
    public OrderTrackerRequest getBody() {
        return this.body;
    }

    @JsonSetter(value="body")
    public void setBody(OrderTrackerRequest body) {
        this.body = body;
    }

    @JsonGetter(value="PayPal-Auth-Assertion")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return this.paypalAuthAssertion;
    }

    @JsonSetter(value="PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    public String toString() {
        return "CreateOrderTrackingInput [id=" + this.id + ", contentType=" + this.contentType + ", body=" + this.body + ", paypalAuthAssertion=" + this.paypalAuthAssertion + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.id, this.contentType, this.body).paypalAuthAssertion(this.getPaypalAuthAssertion());
        return builder;
    }

    public static class Builder {
        private String id;
        private String contentType = "application/json";
        private OrderTrackerRequest body;
        private String paypalAuthAssertion;

        public Builder() {
        }

        public Builder(String id, String contentType, OrderTrackerRequest body) {
            this.id = id;
            this.contentType = contentType;
            this.body = body;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder body(OrderTrackerRequest body) {
            this.body = body;
            return this;
        }

        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        public CreateOrderTrackingInput build() {
            return new CreateOrderTrackingInput(this.id, this.contentType, this.body, this.paypalAuthAssertion);
        }
    }
}

