/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.GooglePayCardResponse;
import com.paypal.sdk.models.PhoneNumberWithCountryCode;

public class GooglePayWalletResponse {
    private String name;
    private String emailAddress;
    private PhoneNumberWithCountryCode phoneNumber;
    private GooglePayCardResponse card;

    public GooglePayWalletResponse() {
    }

    public GooglePayWalletResponse(String name, String emailAddress, PhoneNumberWithCountryCode phoneNumber, GooglePayCardResponse card) {
        this.name = name;
        this.emailAddress = emailAddress;
        this.phoneNumber = phoneNumber;
        this.card = card;
    }

    @JsonGetter(value="name")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getName() {
        return this.name;
    }

    @JsonSetter(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonGetter(value="email_address")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getEmailAddress() {
        return this.emailAddress;
    }

    @JsonSetter(value="email_address")
    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    @JsonGetter(value="phone_number")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PhoneNumberWithCountryCode getPhoneNumber() {
        return this.phoneNumber;
    }

    @JsonSetter(value="phone_number")
    public void setPhoneNumber(PhoneNumberWithCountryCode phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @JsonGetter(value="card")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public GooglePayCardResponse getCard() {
        return this.card;
    }

    @JsonSetter(value="card")
    public void setCard(GooglePayCardResponse card) {
        this.card = card;
    }

    public String toString() {
        return "GooglePayWalletResponse [name=" + this.name + ", emailAddress=" + this.emailAddress + ", phoneNumber=" + this.phoneNumber + ", card=" + this.card + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().name(this.getName()).emailAddress(this.getEmailAddress()).phoneNumber(this.getPhoneNumber()).card(this.getCard());
        return builder;
    }

    public static class Builder {
        private String name;
        private String emailAddress;
        private PhoneNumberWithCountryCode phoneNumber;
        private GooglePayCardResponse card;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public Builder phoneNumber(PhoneNumberWithCountryCode phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        public Builder card(GooglePayCardResponse card) {
            this.card = card;
            return this;
        }

        public GooglePayWalletResponse build() {
            return new GooglePayWalletResponse(this.name, this.emailAddress, this.phoneNumber, this.card);
        }
    }
}

