/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.CaptureStatus;
import com.paypal.sdk.models.CaptureStatusDetails;
import com.paypal.sdk.models.DisbursementMode;
import com.paypal.sdk.models.LinkDescription;
import com.paypal.sdk.models.Money;
import com.paypal.sdk.models.NetworkTransactionReference;
import com.paypal.sdk.models.ProcessorResponse;
import com.paypal.sdk.models.SellerProtection;
import com.paypal.sdk.models.SellerReceivableBreakdown;
import java.util.List;

public class OrdersCapture {
    private CaptureStatus status;
    private CaptureStatusDetails statusDetails;
    private String id;
    private Money amount;
    private String invoiceId;
    private String customId;
    private NetworkTransactionReference networkTransactionReference;
    private SellerProtection sellerProtection;
    private Boolean finalCapture;
    private SellerReceivableBreakdown sellerReceivableBreakdown;
    private DisbursementMode disbursementMode;
    private List<LinkDescription> links;
    private ProcessorResponse processorResponse;
    private String createTime;
    private String updateTime;

    public OrdersCapture() {
        this.finalCapture = false;
        this.disbursementMode = DisbursementMode.INSTANT;
    }

    public OrdersCapture(CaptureStatus status, CaptureStatusDetails statusDetails, String id, Money amount, String invoiceId, String customId, NetworkTransactionReference networkTransactionReference, SellerProtection sellerProtection, Boolean finalCapture, SellerReceivableBreakdown sellerReceivableBreakdown, DisbursementMode disbursementMode, List<LinkDescription> links, ProcessorResponse processorResponse, String createTime, String updateTime) {
        this.status = status;
        this.statusDetails = statusDetails;
        this.id = id;
        this.amount = amount;
        this.invoiceId = invoiceId;
        this.customId = customId;
        this.networkTransactionReference = networkTransactionReference;
        this.sellerProtection = sellerProtection;
        this.finalCapture = finalCapture;
        this.sellerReceivableBreakdown = sellerReceivableBreakdown;
        this.disbursementMode = disbursementMode;
        this.links = links;
        this.processorResponse = processorResponse;
        this.createTime = createTime;
        this.updateTime = updateTime;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CaptureStatus getStatus() {
        return this.status;
    }

    @JsonSetter(value="status")
    public void setStatus(CaptureStatus status) {
        this.status = status;
    }

    @JsonGetter(value="status_details")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public CaptureStatusDetails getStatusDetails() {
        return this.statusDetails;
    }

    @JsonSetter(value="status_details")
    public void setStatusDetails(CaptureStatusDetails statusDetails) {
        this.statusDetails = statusDetails;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="amount")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Money getAmount() {
        return this.amount;
    }

    @JsonSetter(value="amount")
    public void setAmount(Money amount) {
        this.amount = amount;
    }

    @JsonGetter(value="invoice_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getInvoiceId() {
        return this.invoiceId;
    }

    @JsonSetter(value="invoice_id")
    public void setInvoiceId(String invoiceId) {
        this.invoiceId = invoiceId;
    }

    @JsonGetter(value="custom_id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCustomId() {
        return this.customId;
    }

    @JsonSetter(value="custom_id")
    public void setCustomId(String customId) {
        this.customId = customId;
    }

    @JsonGetter(value="network_transaction_reference")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public NetworkTransactionReference getNetworkTransactionReference() {
        return this.networkTransactionReference;
    }

    @JsonSetter(value="network_transaction_reference")
    public void setNetworkTransactionReference(NetworkTransactionReference networkTransactionReference) {
        this.networkTransactionReference = networkTransactionReference;
    }

    @JsonGetter(value="seller_protection")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SellerProtection getSellerProtection() {
        return this.sellerProtection;
    }

    @JsonSetter(value="seller_protection")
    public void setSellerProtection(SellerProtection sellerProtection) {
        this.sellerProtection = sellerProtection;
    }

    @JsonGetter(value="final_capture")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getFinalCapture() {
        return this.finalCapture;
    }

    @JsonSetter(value="final_capture")
    public void setFinalCapture(Boolean finalCapture) {
        this.finalCapture = finalCapture;
    }

    @JsonGetter(value="seller_receivable_breakdown")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SellerReceivableBreakdown getSellerReceivableBreakdown() {
        return this.sellerReceivableBreakdown;
    }

    @JsonSetter(value="seller_receivable_breakdown")
    public void setSellerReceivableBreakdown(SellerReceivableBreakdown sellerReceivableBreakdown) {
        this.sellerReceivableBreakdown = sellerReceivableBreakdown;
    }

    @JsonGetter(value="disbursement_mode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public DisbursementMode getDisbursementMode() {
        return this.disbursementMode;
    }

    @JsonSetter(value="disbursement_mode")
    public void setDisbursementMode(DisbursementMode disbursementMode) {
        this.disbursementMode = disbursementMode;
    }

    @JsonGetter(value="links")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LinkDescription> getLinks() {
        return this.links;
    }

    @JsonSetter(value="links")
    public void setLinks(List<LinkDescription> links) {
        this.links = links;
    }

    @JsonGetter(value="processor_response")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public ProcessorResponse getProcessorResponse() {
        return this.processorResponse;
    }

    @JsonSetter(value="processor_response")
    public void setProcessorResponse(ProcessorResponse processorResponse) {
        this.processorResponse = processorResponse;
    }

    @JsonGetter(value="create_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getCreateTime() {
        return this.createTime;
    }

    @JsonSetter(value="create_time")
    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @JsonGetter(value="update_time")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getUpdateTime() {
        return this.updateTime;
    }

    @JsonSetter(value="update_time")
    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String toString() {
        return "OrdersCapture [status=" + (Object)((Object)this.status) + ", statusDetails=" + this.statusDetails + ", id=" + this.id + ", amount=" + this.amount + ", invoiceId=" + this.invoiceId + ", customId=" + this.customId + ", networkTransactionReference=" + this.networkTransactionReference + ", sellerProtection=" + this.sellerProtection + ", finalCapture=" + this.finalCapture + ", sellerReceivableBreakdown=" + this.sellerReceivableBreakdown + ", disbursementMode=" + (Object)((Object)this.disbursementMode) + ", links=" + this.links + ", processorResponse=" + this.processorResponse + ", createTime=" + this.createTime + ", updateTime=" + this.updateTime + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().status(this.getStatus()).statusDetails(this.getStatusDetails()).id(this.getId()).amount(this.getAmount()).invoiceId(this.getInvoiceId()).customId(this.getCustomId()).networkTransactionReference(this.getNetworkTransactionReference()).sellerProtection(this.getSellerProtection()).finalCapture(this.getFinalCapture()).sellerReceivableBreakdown(this.getSellerReceivableBreakdown()).disbursementMode(this.getDisbursementMode()).links(this.getLinks()).processorResponse(this.getProcessorResponse()).createTime(this.getCreateTime()).updateTime(this.getUpdateTime());
        return builder;
    }

    public static class Builder {
        private CaptureStatus status;
        private CaptureStatusDetails statusDetails;
        private String id;
        private Money amount;
        private String invoiceId;
        private String customId;
        private NetworkTransactionReference networkTransactionReference;
        private SellerProtection sellerProtection;
        private Boolean finalCapture = false;
        private SellerReceivableBreakdown sellerReceivableBreakdown;
        private DisbursementMode disbursementMode = DisbursementMode.INSTANT;
        private List<LinkDescription> links;
        private ProcessorResponse processorResponse;
        private String createTime;
        private String updateTime;

        public Builder status(CaptureStatus status) {
            this.status = status;
            return this;
        }

        public Builder statusDetails(CaptureStatusDetails statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder amount(Money amount) {
            this.amount = amount;
            return this;
        }

        public Builder invoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        public Builder customId(String customId) {
            this.customId = customId;
            return this;
        }

        public Builder networkTransactionReference(NetworkTransactionReference networkTransactionReference) {
            this.networkTransactionReference = networkTransactionReference;
            return this;
        }

        public Builder sellerProtection(SellerProtection sellerProtection) {
            this.sellerProtection = sellerProtection;
            return this;
        }

        public Builder finalCapture(Boolean finalCapture) {
            this.finalCapture = finalCapture;
            return this;
        }

        public Builder sellerReceivableBreakdown(SellerReceivableBreakdown sellerReceivableBreakdown) {
            this.sellerReceivableBreakdown = sellerReceivableBreakdown;
            return this;
        }

        public Builder disbursementMode(DisbursementMode disbursementMode) {
            this.disbursementMode = disbursementMode;
            return this;
        }

        public Builder links(List<LinkDescription> links) {
            this.links = links;
            return this;
        }

        public Builder processorResponse(ProcessorResponse processorResponse) {
            this.processorResponse = processorResponse;
            return this;
        }

        public Builder createTime(String createTime) {
            this.createTime = createTime;
            return this;
        }

        public Builder updateTime(String updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public OrdersCapture build() {
            return new OrdersCapture(this.status, this.statusDetails, this.id, this.amount, this.invoiceId, this.customId, this.networkTransactionReference, this.sellerProtection, this.finalCapture, this.sellerReceivableBreakdown, this.disbursementMode, this.links, this.processorResponse, this.createTime, this.updateTime);
        }
    }
}

