/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public enum PaymentTokenStatus {
    CREATED,
    PAYER_ACTION_REQUIRED,
    APPROVED,
    VAULTED,
    TOKENIZED,
    _UNKNOWN;

    private static TreeMap<String, PaymentTokenStatus> valueMap;
    private String value;

    @JsonCreator
    public static PaymentTokenStatus constructFromString(String toConvert) throws IOException {
        PaymentTokenStatus enumValue = PaymentTokenStatus.fromString(toConvert);
        if (enumValue == null) {
            throw new IOException("Unable to create enum instance with value: " + toConvert);
        }
        return enumValue;
    }

    public static PaymentTokenStatus fromString(String toConvert) {
        if (!valueMap.containsKey(toConvert)) {
            return _UNKNOWN;
        }
        return valueMap.get(toConvert);
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    public String toString() {
        if (this.value == null) {
            return null;
        }
        return this.value.toString();
    }

    public static List<String> toValue(List<PaymentTokenStatus> toConvert) {
        if (toConvert == null) {
            return null;
        }
        ArrayList<String> convertedValues = new ArrayList<String>();
        for (PaymentTokenStatus enumValue : toConvert) {
            convertedValues.add(enumValue.value);
        }
        return convertedValues;
    }

    static {
        valueMap = new TreeMap();
        PaymentTokenStatus.CREATED.value = "CREATED";
        PaymentTokenStatus.PAYER_ACTION_REQUIRED.value = "PAYER_ACTION_REQUIRED";
        PaymentTokenStatus.APPROVED.value = "APPROVED";
        PaymentTokenStatus.VAULTED.value = "VAULTED";
        PaymentTokenStatus.TOKENIZED.value = "TOKENIZED";
        PaymentTokenStatus._UNKNOWN.value = null;
        valueMap.put("CREATED", CREATED);
        valueMap.put("PAYER_ACTION_REQUIRED", PAYER_ACTION_REQUIRED);
        valueMap.put("APPROVED", APPROVED);
        valueMap.put("VAULTED", VAULTED);
        valueMap.put("TOKENIZED", TOKENIZED);
    }
}

