/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.Customer;
import com.paypal.sdk.models.LinkDescription;
import com.paypal.sdk.models.PaymentTokenStatus;
import com.paypal.sdk.models.SetupTokenResponsePaymentSource;
import java.util.List;

public class SetupTokenResponse {
    private String id;
    private Customer customer;
    private PaymentTokenStatus status;
    private SetupTokenResponsePaymentSource paymentSource;
    private List<LinkDescription> links;

    public SetupTokenResponse() {
        this.status = PaymentTokenStatus.CREATED;
    }

    public SetupTokenResponse(String id, Customer customer, PaymentTokenStatus status, SetupTokenResponsePaymentSource paymentSource, List<LinkDescription> links) {
        this.id = id;
        this.customer = customer;
        this.status = status;
        this.paymentSource = paymentSource;
        this.links = links;
    }

    @JsonGetter(value="id")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getId() {
        return this.id;
    }

    @JsonSetter(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonGetter(value="customer")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Customer getCustomer() {
        return this.customer;
    }

    @JsonSetter(value="customer")
    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @JsonGetter(value="status")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public PaymentTokenStatus getStatus() {
        return this.status;
    }

    @JsonSetter(value="status")
    public void setStatus(PaymentTokenStatus status) {
        this.status = status;
    }

    @JsonGetter(value="payment_source")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public SetupTokenResponsePaymentSource getPaymentSource() {
        return this.paymentSource;
    }

    @JsonSetter(value="payment_source")
    public void setPaymentSource(SetupTokenResponsePaymentSource paymentSource) {
        this.paymentSource = paymentSource;
    }

    @JsonGetter(value="links")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<LinkDescription> getLinks() {
        return this.links;
    }

    @JsonSetter(value="links")
    public void setLinks(List<LinkDescription> links) {
        this.links = links;
    }

    public String toString() {
        return "SetupTokenResponse [id=" + this.id + ", customer=" + this.customer + ", status=" + (Object)((Object)this.status) + ", paymentSource=" + this.paymentSource + ", links=" + this.links + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder().id(this.getId()).customer(this.getCustomer()).status(this.getStatus()).paymentSource(this.getPaymentSource()).links(this.getLinks());
        return builder;
    }

    public static class Builder {
        private String id;
        private Customer customer;
        private PaymentTokenStatus status = PaymentTokenStatus.CREATED;
        private SetupTokenResponsePaymentSource paymentSource;
        private List<LinkDescription> links;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public Builder status(PaymentTokenStatus status) {
            this.status = status;
            return this;
        }

        public Builder paymentSource(SetupTokenResponsePaymentSource paymentSource) {
            this.paymentSource = paymentSource;
            return this;
        }

        public Builder links(List<LinkDescription> links) {
            this.links = links;
            return this;
        }

        public SetupTokenResponse build() {
            return new SetupTokenResponse(this.id, this.customer, this.status, this.paymentSource, this.links);
        }
    }
}

