/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.models.StoreInVaultInstruction;
import com.paypal.sdk.models.VenmoPaymentTokenCustomerType;
import com.paypal.sdk.models.VenmoPaymentTokenUsagePattern;
import com.paypal.sdk.models.VenmoPaymentTokenUsageType;

public class VenmoWalletVaultAttributes {
    private StoreInVaultInstruction storeInVault;
    private String description;
    private VenmoPaymentTokenUsagePattern usagePattern;
    private VenmoPaymentTokenUsageType usageType;
    private VenmoPaymentTokenCustomerType customerType;
    private Boolean permitMultiplePaymentTokens;

    public VenmoWalletVaultAttributes() {
        this.customerType = VenmoPaymentTokenCustomerType.CONSUMER;
        this.permitMultiplePaymentTokens = false;
    }

    public VenmoWalletVaultAttributes(StoreInVaultInstruction storeInVault, VenmoPaymentTokenUsageType usageType, String description, VenmoPaymentTokenUsagePattern usagePattern, VenmoPaymentTokenCustomerType customerType, Boolean permitMultiplePaymentTokens) {
        this.storeInVault = storeInVault;
        this.description = description;
        this.usagePattern = usagePattern;
        this.usageType = usageType;
        this.customerType = customerType;
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    @JsonGetter(value="store_in_vault")
    public StoreInVaultInstruction getStoreInVault() {
        return this.storeInVault;
    }

    @JsonSetter(value="store_in_vault")
    public void setStoreInVault(StoreInVaultInstruction storeInVault) {
        this.storeInVault = storeInVault;
    }

    @JsonGetter(value="description")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getDescription() {
        return this.description;
    }

    @JsonSetter(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonGetter(value="usage_pattern")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VenmoPaymentTokenUsagePattern getUsagePattern() {
        return this.usagePattern;
    }

    @JsonSetter(value="usage_pattern")
    public void setUsagePattern(VenmoPaymentTokenUsagePattern usagePattern) {
        this.usagePattern = usagePattern;
    }

    @JsonGetter(value="usage_type")
    public VenmoPaymentTokenUsageType getUsageType() {
        return this.usageType;
    }

    @JsonSetter(value="usage_type")
    public void setUsageType(VenmoPaymentTokenUsageType usageType) {
        this.usageType = usageType;
    }

    @JsonGetter(value="customer_type")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public VenmoPaymentTokenCustomerType getCustomerType() {
        return this.customerType;
    }

    @JsonSetter(value="customer_type")
    public void setCustomerType(VenmoPaymentTokenCustomerType customerType) {
        this.customerType = customerType;
    }

    @JsonGetter(value="permit_multiple_payment_tokens")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Boolean getPermitMultiplePaymentTokens() {
        return this.permitMultiplePaymentTokens;
    }

    @JsonSetter(value="permit_multiple_payment_tokens")
    public void setPermitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
        this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
    }

    public String toString() {
        return "VenmoWalletVaultAttributes [storeInVault=" + (Object)((Object)this.storeInVault) + ", usageType=" + (Object)((Object)this.usageType) + ", description=" + this.description + ", usagePattern=" + (Object)((Object)this.usagePattern) + ", customerType=" + (Object)((Object)this.customerType) + ", permitMultiplePaymentTokens=" + this.permitMultiplePaymentTokens + "]";
    }

    public Builder toBuilder() {
        Builder builder = new Builder(this.storeInVault, this.usageType).description(this.getDescription()).usagePattern(this.getUsagePattern()).customerType(this.getCustomerType()).permitMultiplePaymentTokens(this.getPermitMultiplePaymentTokens());
        return builder;
    }

    public static class Builder {
        private StoreInVaultInstruction storeInVault;
        private VenmoPaymentTokenUsageType usageType;
        private String description;
        private VenmoPaymentTokenUsagePattern usagePattern;
        private VenmoPaymentTokenCustomerType customerType = VenmoPaymentTokenCustomerType.CONSUMER;
        private Boolean permitMultiplePaymentTokens = false;

        public Builder() {
        }

        public Builder(StoreInVaultInstruction storeInVault, VenmoPaymentTokenUsageType usageType) {
            this.storeInVault = storeInVault;
            this.usageType = usageType;
        }

        public Builder storeInVault(StoreInVaultInstruction storeInVault) {
            this.storeInVault = storeInVault;
            return this;
        }

        public Builder usageType(VenmoPaymentTokenUsageType usageType) {
            this.usageType = usageType;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder usagePattern(VenmoPaymentTokenUsagePattern usagePattern) {
            this.usagePattern = usagePattern;
            return this;
        }

        public Builder customerType(VenmoPaymentTokenCustomerType customerType) {
            this.customerType = customerType;
            return this;
        }

        public Builder permitMultiplePaymentTokens(Boolean permitMultiplePaymentTokens) {
            this.permitMultiplePaymentTokens = permitMultiplePaymentTokens;
            return this;
        }

        public VenmoWalletVaultAttributes build() {
            return new VenmoWalletVaultAttributes(this.storeInVault, this.usageType, this.description, this.usagePattern, this.customerType, this.permitMultiplePaymentTokens);
        }
    }
}

