/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.paypal.sdk.ApiHelper;
import com.paypal.sdk.Server;
import com.paypal.sdk.exceptions.ApiException;
import com.paypal.sdk.exceptions.ErrorException;
import com.paypal.sdk.http.request.HttpMethod;
import com.paypal.sdk.http.response.ApiResponse;
import com.paypal.sdk.models.CaptureAuthorizedPaymentInput;
import com.paypal.sdk.models.CapturedPayment;
import com.paypal.sdk.models.GetAuthorizedPaymentInput;
import com.paypal.sdk.models.GetCapturedPaymentInput;
import com.paypal.sdk.models.GetRefundInput;
import com.paypal.sdk.models.PaymentAuthorization;
import com.paypal.sdk.models.ReauthorizePaymentInput;
import com.paypal.sdk.models.Refund;
import com.paypal.sdk.models.RefundCapturedPaymentInput;
import com.paypal.sdk.models.VoidPaymentInput;
import io.apimatic.core.ApiCall;
import io.apimatic.core.ErrorCase;
import io.apimatic.core.GlobalConfiguration;
import io.apimatic.coreinterfaces.http.request.ResponseClassType;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

/**
 * This class lists all the endpoints of the groups.
 */
public final class PaymentsController extends BaseController {

    /**
     * Initializes the controller.
     * @param globalConfig    Configurations added in client.
     */
    public PaymentsController(GlobalConfiguration globalConfig) {
        super(globalConfig);
    }

    /**
     * Captures an authorized payment, by ID.
     * @param  input  CaptureAuthorizedPaymentInput object containing request parameters
     * @return    Returns the CapturedPayment wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<CapturedPayment> captureAuthorizedPayment(
            final CaptureAuthorizedPaymentInput input) throws ApiException, IOException {
        return prepareCaptureAuthorizedPaymentRequest(input).execute();
    }

    /**
     * Captures an authorized payment, by ID.
     * @param  input  CaptureAuthorizedPaymentInput object containing request parameters
     * @return    Returns the CapturedPayment wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<CapturedPayment>> captureAuthorizedPaymentAsync(
            final CaptureAuthorizedPaymentInput input) {
        try { 
            return prepareCaptureAuthorizedPaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for captureAuthorizedPayment.
     */
    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareCaptureAuthorizedPaymentRequest(
            final CaptureAuthorizedPaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder<ApiResponse<CapturedPayment>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/authorizations/{authorization_id}/capture")
                        .bodyParam(param -> param.value(input.getBody()).isRequired(false))
                        .bodySerializer(() ->  ApiHelper.serialize(input.getBody()))
                        .templateParam(param -> param.key("authorization_id").value(input.getAuthorizationId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("Content-Type")
                                .value("application/json").isRequired(false))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Request-Id")
                                .value(input.getPaypalRequestId()).isRequired(false))
                        .headerParam(param -> param.key("Prefer")
                                .value(input.getPrefer()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.POST))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, CapturedPayment.class))
                        .nullify404(false)
                        .localErrorCase("400",
                                 ErrorCase.setReason("The request failed because it is not well-formed or is syntactically incorrect or violates schema.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("403",
                                 ErrorCase.setReason("The request failed because the caller has insufficient permissions.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("409",
                                 ErrorCase.setReason("The server has detected a conflict while processing this request.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("422",
                                 ErrorCase.setReason("The request failed because it is semantically incorrect or failed business validation.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Shows details for a captured payment, by ID.
     * @param  input  GetCapturedPaymentInput object containing request parameters
     * @return    Returns the CapturedPayment wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<CapturedPayment> getCapturedPayment(
            final GetCapturedPaymentInput input) throws ApiException, IOException {
        return prepareGetCapturedPaymentRequest(input).execute();
    }

    /**
     * Shows details for a captured payment, by ID.
     * @param  input  GetCapturedPaymentInput object containing request parameters
     * @return    Returns the CapturedPayment wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<CapturedPayment>> getCapturedPaymentAsync(
            final GetCapturedPaymentInput input) {
        try { 
            return prepareGetCapturedPaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for getCapturedPayment.
     */
    private ApiCall<ApiResponse<CapturedPayment>, ApiException> prepareGetCapturedPaymentRequest(
            final GetCapturedPaymentInput input) throws IOException {
        return new ApiCall.Builder<ApiResponse<CapturedPayment>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/captures/{capture_id}")
                        .templateParam(param -> param.key("capture_id").value(input.getCaptureId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.GET))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, CapturedPayment.class))
                        .nullify404(false)
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("403",
                                 ErrorCase.setReason("The request failed because the caller has insufficient permissions.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Reauthorizes an authorized PayPal account payment, by ID. To ensure that funds are still
     * available, reauthorize a payment after its initial three-day honor period expires. Within the
     * 29-day authorization period, you can issue multiple re-authorizations after the honor period
     * expires. If 30 days have transpired since the date of the original authorization, you must
     * create an authorized payment instead of reauthorizing the original authorized payment. A
     * reauthorized payment itself has a new honor period of three days. You can reauthorize an
     * authorized payment from 4 to 29 days after the 3-day honor period. The allowed amount depends
     * on context and geography, for example in US it is up to 115% of the original authorized
     * amount, not to exceed an increase of $75 USD. Supports only the `amount` request parameter.
     * Note: This request is currently not supported for Partner use cases.
     * @param  input  ReauthorizePaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<PaymentAuthorization> reauthorizePayment(
            final ReauthorizePaymentInput input) throws ApiException, IOException {
        return prepareReauthorizePaymentRequest(input).execute();
    }

    /**
     * Reauthorizes an authorized PayPal account payment, by ID. To ensure that funds are still
     * available, reauthorize a payment after its initial three-day honor period expires. Within the
     * 29-day authorization period, you can issue multiple re-authorizations after the honor period
     * expires. If 30 days have transpired since the date of the original authorization, you must
     * create an authorized payment instead of reauthorizing the original authorized payment. A
     * reauthorized payment itself has a new honor period of three days. You can reauthorize an
     * authorized payment from 4 to 29 days after the 3-day honor period. The allowed amount depends
     * on context and geography, for example in US it is up to 115% of the original authorized
     * amount, not to exceed an increase of $75 USD. Supports only the `amount` request parameter.
     * Note: This request is currently not supported for Partner use cases.
     * @param  input  ReauthorizePaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<PaymentAuthorization>> reauthorizePaymentAsync(
            final ReauthorizePaymentInput input) {
        try { 
            return prepareReauthorizePaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for reauthorizePayment.
     */
    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareReauthorizePaymentRequest(
            final ReauthorizePaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder<ApiResponse<PaymentAuthorization>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/authorizations/{authorization_id}/reauthorize")
                        .bodyParam(param -> param.value(input.getBody()).isRequired(false))
                        .bodySerializer(() ->  ApiHelper.serialize(input.getBody()))
                        .templateParam(param -> param.key("authorization_id").value(input.getAuthorizationId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("Content-Type")
                                .value("application/json").isRequired(false))
                        .headerParam(param -> param.key("PayPal-Request-Id")
                                .value(input.getPaypalRequestId()).isRequired(false))
                        .headerParam(param -> param.key("Prefer")
                                .value(input.getPrefer()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.POST))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, PaymentAuthorization.class))
                        .nullify404(false)
                        .localErrorCase("400",
                                 ErrorCase.setReason("The request failed because it is not well-formed or is syntactically incorrect or violates schema.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("422",
                                 ErrorCase.setReason("The request failed because it either is semantically incorrect or failed business validation.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Voids, or cancels, an authorized payment, by ID. You cannot void an authorized payment that
     * has been fully captured.
     * @param  input  VoidPaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<PaymentAuthorization> voidPayment(
            final VoidPaymentInput input) throws ApiException, IOException {
        return prepareVoidPaymentRequest(input).execute();
    }

    /**
     * Voids, or cancels, an authorized payment, by ID. You cannot void an authorized payment that
     * has been fully captured.
     * @param  input  VoidPaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<PaymentAuthorization>> voidPaymentAsync(
            final VoidPaymentInput input) {
        try { 
            return prepareVoidPaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for voidPayment.
     */
    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareVoidPaymentRequest(
            final VoidPaymentInput input) throws IOException {
        return new ApiCall.Builder<ApiResponse<PaymentAuthorization>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/authorizations/{authorization_id}/void")
                        .templateParam(param -> param.key("authorization_id").value(input.getAuthorizationId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Request-Id")
                                .value(input.getPaypalRequestId()).isRequired(false))
                        .headerParam(param -> param.key("Prefer")
                                .value(input.getPrefer()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.POST))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, PaymentAuthorization.class))
                        .nullableResponseType(true)
                        .nullify404(false)
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("403",
                                 ErrorCase.setReason("The request failed because the caller has insufficient permissions.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("409",
                                 ErrorCase.setReason("The request failed because a previous call for the given resource is in progress.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("422",
                                 ErrorCase.setReason("The request failed because it either is semantically incorrect or failed business validation.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Refunds a captured payment, by ID. For a full refund, include an empty payload in the JSON
     * request body. For a partial refund, include an amount object in the JSON request body.
     * @param  input  RefundCapturedPaymentInput object containing request parameters
     * @return    Returns the Refund wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<Refund> refundCapturedPayment(
            final RefundCapturedPaymentInput input) throws ApiException, IOException {
        return prepareRefundCapturedPaymentRequest(input).execute();
    }

    /**
     * Refunds a captured payment, by ID. For a full refund, include an empty payload in the JSON
     * request body. For a partial refund, include an amount object in the JSON request body.
     * @param  input  RefundCapturedPaymentInput object containing request parameters
     * @return    Returns the Refund wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<Refund>> refundCapturedPaymentAsync(
            final RefundCapturedPaymentInput input) {
        try { 
            return prepareRefundCapturedPaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for refundCapturedPayment.
     */
    private ApiCall<ApiResponse<Refund>, ApiException> prepareRefundCapturedPaymentRequest(
            final RefundCapturedPaymentInput input) throws JsonProcessingException, IOException {
        return new ApiCall.Builder<ApiResponse<Refund>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/captures/{capture_id}/refund")
                        .bodyParam(param -> param.value(input.getBody()).isRequired(false))
                        .bodySerializer(() ->  ApiHelper.serialize(input.getBody()))
                        .templateParam(param -> param.key("capture_id").value(input.getCaptureId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("Content-Type")
                                .value("application/json").isRequired(false))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Request-Id")
                                .value(input.getPaypalRequestId()).isRequired(false))
                        .headerParam(param -> param.key("Prefer")
                                .value(input.getPrefer()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.POST))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, Refund.class))
                        .nullify404(false)
                        .localErrorCase("400",
                                 ErrorCase.setReason("The request failed because it is not well-formed or is syntactically incorrect or violates schema.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("403",
                                 ErrorCase.setReason("The request failed because the caller has insufficient permissions.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("409",
                                 ErrorCase.setReason("The request failed because a previous call for the given resource is in progress.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("422",
                                 ErrorCase.setReason("The request failed because it either is semantically incorrect or failed business validation.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Shows details for an authorized payment, by ID.
     * @param  input  GetAuthorizedPaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<PaymentAuthorization> getAuthorizedPayment(
            final GetAuthorizedPaymentInput input) throws ApiException, IOException {
        return prepareGetAuthorizedPaymentRequest(input).execute();
    }

    /**
     * Shows details for an authorized payment, by ID.
     * @param  input  GetAuthorizedPaymentInput object containing request parameters
     * @return    Returns the PaymentAuthorization wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<PaymentAuthorization>> getAuthorizedPaymentAsync(
            final GetAuthorizedPaymentInput input) {
        try { 
            return prepareGetAuthorizedPaymentRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for getAuthorizedPayment.
     */
    private ApiCall<ApiResponse<PaymentAuthorization>, ApiException> prepareGetAuthorizedPaymentRequest(
            final GetAuthorizedPaymentInput input) throws IOException {
        return new ApiCall.Builder<ApiResponse<PaymentAuthorization>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/authorizations/{authorization_id}")
                        .templateParam(param -> param.key("authorization_id").value(input.getAuthorizationId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.GET))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, PaymentAuthorization.class))
                        .nullify404(false)
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }

    /**
     * Shows details for a refund, by ID.
     * @param  input  GetRefundInput object containing request parameters
     * @return    Returns the Refund wrapped in ApiResponse response from the API call
     * @throws    ApiException    Represents error response from the server.
     * @throws    IOException    Signals that an I/O exception of some sort has occurred.
     */
    public ApiResponse<Refund> getRefund(
            final GetRefundInput input) throws ApiException, IOException {
        return prepareGetRefundRequest(input).execute();
    }

    /**
     * Shows details for a refund, by ID.
     * @param  input  GetRefundInput object containing request parameters
     * @return    Returns the Refund wrapped in ApiResponse response from the API call
     */
    public CompletableFuture<ApiResponse<Refund>> getRefundAsync(
            final GetRefundInput input) {
        try { 
            return prepareGetRefundRequest(input).executeAsync(); 
        } catch (Exception e) {  
            throw new CompletionException(e); 
        }
    }

    /**
     * Builds the ApiCall object for getRefund.
     */
    private ApiCall<ApiResponse<Refund>, ApiException> prepareGetRefundRequest(
            final GetRefundInput input) throws IOException {
        return new ApiCall.Builder<ApiResponse<Refund>, ApiException>()
                .globalConfig(getGlobalConfiguration())
                .requestBuilder(requestBuilder -> requestBuilder
                        .server(Server.ENUM_DEFAULT.value())
                        .path("/v2/payments/refunds/{refund_id}")
                        .templateParam(param -> param.key("refund_id").value(input.getRefundId())
                                .shouldEncode(true))
                        .headerParam(param -> param.key("PayPal-Mock-Response")
                                .value(input.getPaypalMockResponse()).isRequired(false))
                        .headerParam(param -> param.key("PayPal-Auth-Assertion")
                                .value(input.getPaypalAuthAssertion()).isRequired(false))
                        .headerParam(param -> param.key("accept").value("application/json"))
                        .withAuth(auth -> auth
                                .add("Oauth2"))
                        .httpMethod(HttpMethod.GET))
                .responseHandler(responseHandler -> responseHandler
                        .responseClassType(ResponseClassType.API_RESPONSE)
                        .apiResponseDeserializer(
                                response -> ApiHelper.deserialize(response, Refund.class))
                        .nullify404(false)
                        .localErrorCase("401",
                                 ErrorCase.setReason("Authentication failed due to missing authorization header, or invalid authentication credentials.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("403",
                                 ErrorCase.setReason("The request failed because the caller has insufficient permissions.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("404",
                                 ErrorCase.setReason("The request failed because the resource does not exist.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .localErrorCase("500",
                                 ErrorCase.setReason("The request failed because an internal server error occurred.",
                                (reason, context) -> new ApiException(reason, context)))
                        .localErrorCase(ErrorCase.DEFAULT,
                                 ErrorCase.setReason("The error response.",
                                (reason, context) -> new ErrorException(reason, context)))
                        .globalErrorCase(GLOBAL_ERROR_CASES))
                .build();
    }
}