/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for AssuranceDetails type.
 */
public class AssuranceDetails {
    private Boolean accountVerified;
    private Boolean cardHolderAuthenticated;

    /**
     * Default constructor.
     */
    public AssuranceDetails() {
        accountVerified = false;
        cardHolderAuthenticated = false;
    }

    /**
     * Initialization constructor.
     * @param  accountVerified  Boolean value for accountVerified.
     * @param  cardHolderAuthenticated  Boolean value for cardHolderAuthenticated.
     */
    public AssuranceDetails(
            Boolean accountVerified,
            Boolean cardHolderAuthenticated) {
        this.accountVerified = accountVerified;
        this.cardHolderAuthenticated = cardHolderAuthenticated;
    }

    /**
     * Getter for AccountVerified.
     * If true, indicates that Cardholder possession validation has been performed on returned
     * payment credential.
     * @return Returns the Boolean
     */
    @JsonGetter("account_verified")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getAccountVerified() {
        return accountVerified;
    }

    /**
     * Setter for AccountVerified.
     * If true, indicates that Cardholder possession validation has been performed on returned
     * payment credential.
     * @param accountVerified Value for Boolean
     */
    @JsonSetter("account_verified")
    public void setAccountVerified(Boolean accountVerified) {
        this.accountVerified = accountVerified;
    }

    /**
     * Getter for CardHolderAuthenticated.
     * If true, indicates that identification and verifications (ID&amp;V) was performed on the returned
     * payment credential.If false, the same risk-based authentication can be performed as you would
     * for card transactions. This risk-based authentication can include, but not limited to,
     * step-up with 3D Secure protocol if applicable.
     * @return Returns the Boolean
     */
    @JsonGetter("card_holder_authenticated")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getCardHolderAuthenticated() {
        return cardHolderAuthenticated;
    }

    /**
     * Setter for CardHolderAuthenticated.
     * If true, indicates that identification and verifications (ID&amp;V) was performed on the returned
     * payment credential.If false, the same risk-based authentication can be performed as you would
     * for card transactions. This risk-based authentication can include, but not limited to,
     * step-up with 3D Secure protocol if applicable.
     * @param cardHolderAuthenticated Value for Boolean
     */
    @JsonSetter("card_holder_authenticated")
    public void setCardHolderAuthenticated(Boolean cardHolderAuthenticated) {
        this.cardHolderAuthenticated = cardHolderAuthenticated;
    }

    /**
     * Converts this AssuranceDetails into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "AssuranceDetails [" + "accountVerified=" + accountVerified
                + ", cardHolderAuthenticated=" + cardHolderAuthenticated + "]";
    }

    /**
     * Builds a new {@link AssuranceDetails.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link AssuranceDetails.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder()
                .accountVerified(getAccountVerified())
                .cardHolderAuthenticated(getCardHolderAuthenticated());
        return builder;
    }

    /**
     * Class to build instances of {@link AssuranceDetails}.
     */
    public static class Builder {
        private Boolean accountVerified = false;
        private Boolean cardHolderAuthenticated = false;



        /**
         * Setter for accountVerified.
         * @param  accountVerified  Boolean value for accountVerified.
         * @return Builder
         */
        public Builder accountVerified(Boolean accountVerified) {
            this.accountVerified = accountVerified;
            return this;
        }

        /**
         * Setter for cardHolderAuthenticated.
         * @param  cardHolderAuthenticated  Boolean value for cardHolderAuthenticated.
         * @return Builder
         */
        public Builder cardHolderAuthenticated(Boolean cardHolderAuthenticated) {
            this.cardHolderAuthenticated = cardHolderAuthenticated;
            return this;
        }

        /**
         * Builds a new {@link AssuranceDetails} object using the set fields.
         * @return {@link AssuranceDetails}
         */
        public AssuranceDetails build() {
            return new AssuranceDetails(accountVerified, cardHolderAuthenticated);
        }
    }
}
