/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.paypal.sdk.utilities.JsonValue;

/**
 * This is a model class for BillingCycle type.
 */
public class BillingCycle {
    private TenureType tenureType;
    private PricingScheme pricingScheme;
    private JsonValue frequency;
    private Integer totalCycles;
    private Integer sequence;
    private String startDate;

    /**
     * Default constructor.
     */
    public BillingCycle() {
        totalCycles = 1;
        sequence = 1;
    }

    /**
     * Initialization constructor.
     * @param  tenureType  TenureType value for tenureType.
     * @param  pricingScheme  PricingScheme value for pricingScheme.
     * @param  frequency  JsonValue value for frequency.
     * @param  totalCycles  Integer value for totalCycles.
     * @param  sequence  Integer value for sequence.
     * @param  startDate  String value for startDate.
     */
    public BillingCycle(
            TenureType tenureType,
            PricingScheme pricingScheme,
            JsonValue frequency,
            Integer totalCycles,
            Integer sequence,
            String startDate) {
        this.tenureType = tenureType;
        this.pricingScheme = pricingScheme;
        this.frequency = frequency;
        this.totalCycles = totalCycles;
        this.sequence = sequence;
        this.startDate = startDate;
    }

    /**
     * Getter for TenureType.
     * The tenure type of the billing cycle identifies if the billing cycle is a trial(free or
     * discounted) or regular billing cycle.
     * @return Returns the TenureType
     */
    @JsonGetter("tenure_type")
    public TenureType getTenureType() {
        return tenureType;
    }

    /**
     * Setter for TenureType.
     * The tenure type of the billing cycle identifies if the billing cycle is a trial(free or
     * discounted) or regular billing cycle.
     * @param tenureType Value for TenureType
     */
    @JsonSetter("tenure_type")
    public void setTenureType(TenureType tenureType) {
        this.tenureType = tenureType;
    }

    /**
     * Getter for PricingScheme.
     * The pricing scheme details.
     * @return Returns the PricingScheme
     */
    @JsonGetter("pricing_scheme")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PricingScheme getPricingScheme() {
        return pricingScheme;
    }

    /**
     * Setter for PricingScheme.
     * The pricing scheme details.
     * @param pricingScheme Value for PricingScheme
     */
    @JsonSetter("pricing_scheme")
    public void setPricingScheme(PricingScheme pricingScheme) {
        this.pricingScheme = pricingScheme;
    }

    /**
     * Getter for Frequency.
     * The frequency details for this billing cycle.
     * @return Returns the JsonValue
     */
    @JsonGetter("frequency")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public JsonValue getFrequency() {
        return frequency;
    }

    /**
     * Setter for Frequency.
     * The frequency details for this billing cycle.
     * @param frequency Value for JsonValue
     */
    @JsonSetter("frequency")
    public void setFrequency(JsonValue frequency) {
        this.frequency = frequency;
    }

    /**
     * Getter for TotalCycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be
     * executed a finite number of times (value between 1 and 999 for total_cycles). Regular billing
     * cycles can be executed infinite times (value of 0 for total_cycles) or a finite number of
     * times (value between 1 and 999 for total_cycles).
     * @return Returns the Integer
     */
    @JsonGetter("total_cycles")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Integer getTotalCycles() {
        return totalCycles;
    }

    /**
     * Setter for TotalCycles.
     * The number of times this billing cycle gets executed. Trial billing cycles can only be
     * executed a finite number of times (value between 1 and 999 for total_cycles). Regular billing
     * cycles can be executed infinite times (value of 0 for total_cycles) or a finite number of
     * times (value between 1 and 999 for total_cycles).
     * @param totalCycles Value for Integer
     */
    @JsonSetter("total_cycles")
    public void setTotalCycles(Integer totalCycles) {
        this.totalCycles = totalCycles;
    }

    /**
     * Getter for Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial
     * billing cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`,
     * so that trial cycle runs before the regular cycle.
     * @return Returns the Integer
     */
    @JsonGetter("sequence")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Integer getSequence() {
        return sequence;
    }

    /**
     * Setter for Sequence.
     * The order in which this cycle is to run among other billing cycles. For example, a trial
     * billing cycle has a `sequence` of `1` while a regular billing cycle has a `sequence` of `2`,
     * so that trial cycle runs before the regular cycle.
     * @param sequence Value for Integer
     */
    @JsonSetter("sequence")
    public void setSequence(Integer sequence) {
        this.sequence = sequence;
    }

    /**
     * Getter for StartDate.
     * The stand-alone date, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values,
     * such as a date of birth, you should use dates with no associated time or time-zone data.
     * Whenever possible, use the standard `date_time` type. This regular expression does not
     * validate all dates. For example, February 31 is valid and nothing is known about leap years.
     * @return Returns the String
     */
    @JsonGetter("start_date")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getStartDate() {
        return startDate;
    }

    /**
     * Setter for StartDate.
     * The stand-alone date, in [Internet date and time
     * format](https://tools.ietf.org/html/rfc3339#section-5.6). To represent special legal values,
     * such as a date of birth, you should use dates with no associated time or time-zone data.
     * Whenever possible, use the standard `date_time` type. This regular expression does not
     * validate all dates. For example, February 31 is valid and nothing is known about leap years.
     * @param startDate Value for String
     */
    @JsonSetter("start_date")
    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    /**
     * Converts this BillingCycle into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "BillingCycle [" + "tenureType=" + tenureType + ", pricingScheme=" + pricingScheme
                + ", frequency=" + frequency + ", totalCycles=" + totalCycles + ", sequence="
                + sequence + ", startDate=" + startDate + "]";
    }

    /**
     * Builds a new {@link BillingCycle.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link BillingCycle.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(tenureType)
                .pricingScheme(getPricingScheme())
                .frequency(getFrequency())
                .totalCycles(getTotalCycles())
                .sequence(getSequence())
                .startDate(getStartDate());
        return builder;
    }

    /**
     * Class to build instances of {@link BillingCycle}.
     */
    public static class Builder {
        private TenureType tenureType;
        private PricingScheme pricingScheme;
        private JsonValue frequency;
        private Integer totalCycles = 1;
        private Integer sequence = 1;
        private String startDate;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  tenureType  TenureType value for tenureType.
         */
        public Builder(TenureType tenureType) {
            this.tenureType = tenureType;
        }

        /**
         * Setter for tenureType.
         * @param  tenureType  TenureType value for tenureType.
         * @return Builder
         */
        public Builder tenureType(TenureType tenureType) {
            this.tenureType = tenureType;
            return this;
        }

        /**
         * Setter for pricingScheme.
         * @param  pricingScheme  PricingScheme value for pricingScheme.
         * @return Builder
         */
        public Builder pricingScheme(PricingScheme pricingScheme) {
            this.pricingScheme = pricingScheme;
            return this;
        }

        /**
         * Setter for frequency.
         * @param  frequency  JsonValue value for frequency.
         * @return Builder
         */
        public Builder frequency(JsonValue frequency) {
            this.frequency = frequency;
            return this;
        }

        /**
         * Setter for totalCycles.
         * @param  totalCycles  Integer value for totalCycles.
         * @return Builder
         */
        public Builder totalCycles(Integer totalCycles) {
            this.totalCycles = totalCycles;
            return this;
        }

        /**
         * Setter for sequence.
         * @param  sequence  Integer value for sequence.
         * @return Builder
         */
        public Builder sequence(Integer sequence) {
            this.sequence = sequence;
            return this;
        }

        /**
         * Setter for startDate.
         * @param  startDate  String value for startDate.
         * @return Builder
         */
        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        /**
         * Builds a new {@link BillingCycle} object using the set fields.
         * @return {@link BillingCycle}
         */
        public BillingCycle build() {
            return new BillingCycle(tenureType, pricingScheme, frequency, totalCycles, sequence,
                    startDate);
        }
    }
}
