/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for CallbackConfiguration type.
 */
public class CallbackConfiguration {
    private List<CallbackEvents> callbackEvents;
    private String callbackUrl;

    /**
     * Default constructor.
     */
    public CallbackConfiguration() {
    }

    /**
     * Initialization constructor.
     * @param  callbackEvents  List of CallbackEvents value for callbackEvents.
     * @param  callbackUrl  String value for callbackUrl.
     */
    public CallbackConfiguration(
            List<CallbackEvents> callbackEvents,
            String callbackUrl) {
        this.callbackEvents = callbackEvents;
        this.callbackUrl = callbackUrl;
    }

    /**
     * Getter for CallbackEvents.
     * An array of callback events merchant can subscribe to for the corresponding callback url.
     * @return Returns the List of CallbackEvents
     */
    @JsonGetter("callback_events")
    public List<CallbackEvents> getCallbackEvents() {
        return callbackEvents;
    }

    /**
     * Setter for CallbackEvents.
     * An array of callback events merchant can subscribe to for the corresponding callback url.
     * @param callbackEvents Value for List of CallbackEvents
     */
    @JsonSetter("callback_events")
    public void setCallbackEvents(List<CallbackEvents> callbackEvents) {
        this.callbackEvents = callbackEvents;
    }

    /**
     * Getter for CallbackUrl.
     * Merchant provided CallBack url.PayPal/Venmo will use this url to call the merchant back when
     * the events occur .PayPal/Venmo expects a secured url usually in the https format.merchant can
     * append the cart id or other params part of the url as query or path params.
     * @return Returns the String
     */
    @JsonGetter("callback_url")
    public String getCallbackUrl() {
        return callbackUrl;
    }

    /**
     * Setter for CallbackUrl.
     * Merchant provided CallBack url.PayPal/Venmo will use this url to call the merchant back when
     * the events occur .PayPal/Venmo expects a secured url usually in the https format.merchant can
     * append the cart id or other params part of the url as query or path params.
     * @param callbackUrl Value for String
     */
    @JsonSetter("callback_url")
    public void setCallbackUrl(String callbackUrl) {
        this.callbackUrl = callbackUrl;
    }

    /**
     * Converts this CallbackConfiguration into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "CallbackConfiguration [" + "callbackEvents=" + callbackEvents + ", callbackUrl="
                + callbackUrl + "]";
    }

    /**
     * Builds a new {@link CallbackConfiguration.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link CallbackConfiguration.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(callbackEvents, callbackUrl);
        return builder;
    }

    /**
     * Class to build instances of {@link CallbackConfiguration}.
     */
    public static class Builder {
        private List<CallbackEvents> callbackEvents;
        private String callbackUrl;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  callbackEvents  List of CallbackEvents value for callbackEvents.
         * @param  callbackUrl  String value for callbackUrl.
         */
        public Builder(List<CallbackEvents> callbackEvents, String callbackUrl) {
            this.callbackEvents = callbackEvents;
            this.callbackUrl = callbackUrl;
        }

        /**
         * Setter for callbackEvents.
         * @param  callbackEvents  List of CallbackEvents value for callbackEvents.
         * @return Builder
         */
        public Builder callbackEvents(List<CallbackEvents> callbackEvents) {
            this.callbackEvents = callbackEvents;
            return this;
        }

        /**
         * Setter for callbackUrl.
         * @param  callbackUrl  String value for callbackUrl.
         * @return Builder
         */
        public Builder callbackUrl(String callbackUrl) {
            this.callbackUrl = callbackUrl;
            return this;
        }

        /**
         * Builds a new {@link CallbackConfiguration} object using the set fields.
         * @return {@link CallbackConfiguration}
         */
        public CallbackConfiguration build() {
            return new CallbackConfiguration(callbackEvents, callbackUrl);
        }
    }
}
