/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for OrderTrackerRequest type.
 */
public class OrderTrackerRequest {
    private String trackingNumber;
    private ShipmentCarrier carrier;
    private String carrierNameOther;
    private String captureId;
    private Boolean notifyPayer;
    private List<OrderTrackerItem> items;

    /**
     * Default constructor.
     */
    public OrderTrackerRequest() {
        notifyPayer = false;
    }

    /**
     * Initialization constructor.
     * @param  captureId  String value for captureId.
     * @param  trackingNumber  String value for trackingNumber.
     * @param  carrier  ShipmentCarrier value for carrier.
     * @param  carrierNameOther  String value for carrierNameOther.
     * @param  notifyPayer  Boolean value for notifyPayer.
     * @param  items  List of OrderTrackerItem value for items.
     */
    public OrderTrackerRequest(
            String captureId,
            String trackingNumber,
            ShipmentCarrier carrier,
            String carrierNameOther,
            Boolean notifyPayer,
            List<OrderTrackerItem> items) {
        this.trackingNumber = trackingNumber;
        this.carrier = carrier;
        this.carrierNameOther = carrierNameOther;
        this.captureId = captureId;
        this.notifyPayer = notifyPayer;
        this.items = items;
    }

    /**
     * Getter for TrackingNumber.
     * The tracking number for the shipment. This property supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("tracking_number")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getTrackingNumber() {
        return trackingNumber;
    }

    /**
     * Setter for TrackingNumber.
     * The tracking number for the shipment. This property supports Unicode.
     * @param trackingNumber Value for String
     */
    @JsonSetter("tracking_number")
    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    /**
     * Getter for Carrier.
     * The carrier for the shipment. Some carriers have a global version as well as local
     * subsidiaries. The subsidiaries are repeated over many countries and might also have an entry
     * in the global list. Choose the carrier for your country. If the carrier is not available for
     * your country, choose the global version of the carrier. If your carrier name is not in the
     * list, set `carrier` to `OTHER` and set carrier name in `carrier_name_other`. For allowed
     * values, see Carriers.
     * @return Returns the ShipmentCarrier
     */
    @JsonGetter("carrier")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public ShipmentCarrier getCarrier() {
        return carrier;
    }

    /**
     * Setter for Carrier.
     * The carrier for the shipment. Some carriers have a global version as well as local
     * subsidiaries. The subsidiaries are repeated over many countries and might also have an entry
     * in the global list. Choose the carrier for your country. If the carrier is not available for
     * your country, choose the global version of the carrier. If your carrier name is not in the
     * list, set `carrier` to `OTHER` and set carrier name in `carrier_name_other`. For allowed
     * values, see Carriers.
     * @param carrier Value for ShipmentCarrier
     */
    @JsonSetter("carrier")
    public void setCarrier(ShipmentCarrier carrier) {
        this.carrier = carrier;
    }

    /**
     * Getter for CarrierNameOther.
     * The name of the carrier for the shipment. Provide this value only if the carrier parameter is
     * OTHER. This property supports Unicode.
     * @return Returns the String
     */
    @JsonGetter("carrier_name_other")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getCarrierNameOther() {
        return carrierNameOther;
    }

    /**
     * Setter for CarrierNameOther.
     * The name of the carrier for the shipment. Provide this value only if the carrier parameter is
     * OTHER. This property supports Unicode.
     * @param carrierNameOther Value for String
     */
    @JsonSetter("carrier_name_other")
    public void setCarrierNameOther(String carrierNameOther) {
        this.carrierNameOther = carrierNameOther;
    }

    /**
     * Getter for CaptureId.
     * The PayPal capture ID.
     * @return Returns the String
     */
    @JsonGetter("capture_id")
    public String getCaptureId() {
        return captureId;
    }

    /**
     * Setter for CaptureId.
     * The PayPal capture ID.
     * @param captureId Value for String
     */
    @JsonSetter("capture_id")
    public void setCaptureId(String captureId) {
        this.captureId = captureId;
    }

    /**
     * Getter for NotifyPayer.
     * If true, PayPal will send an email notification to the payer of the PayPal transaction. The
     * email contains the tracking details provided through the Orders tracking API request.
     * Independent of any value passed for `notify_payer`, the payer may receive tracking
     * notifications within the PayPal app, based on the user's notification preferences.
     * @return Returns the Boolean
     */
    @JsonGetter("notify_payer")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Boolean getNotifyPayer() {
        return notifyPayer;
    }

    /**
     * Setter for NotifyPayer.
     * If true, PayPal will send an email notification to the payer of the PayPal transaction. The
     * email contains the tracking details provided through the Orders tracking API request.
     * Independent of any value passed for `notify_payer`, the payer may receive tracking
     * notifications within the PayPal app, based on the user's notification preferences.
     * @param notifyPayer Value for Boolean
     */
    @JsonSetter("notify_payer")
    public void setNotifyPayer(Boolean notifyPayer) {
        this.notifyPayer = notifyPayer;
    }

    /**
     * Getter for Items.
     * An array of details of items in the shipment.
     * @return Returns the List of OrderTrackerItem
     */
    @JsonGetter("items")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<OrderTrackerItem> getItems() {
        return items;
    }

    /**
     * Setter for Items.
     * An array of details of items in the shipment.
     * @param items Value for List of OrderTrackerItem
     */
    @JsonSetter("items")
    public void setItems(List<OrderTrackerItem> items) {
        this.items = items;
    }

    /**
     * Converts this OrderTrackerRequest into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "OrderTrackerRequest [" + "captureId=" + captureId + ", trackingNumber="
                + trackingNumber + ", carrier=" + carrier + ", carrierNameOther=" + carrierNameOther
                + ", notifyPayer=" + notifyPayer + ", items=" + items + "]";
    }

    /**
     * Builds a new {@link OrderTrackerRequest.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link OrderTrackerRequest.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(captureId)
                .trackingNumber(getTrackingNumber())
                .carrier(getCarrier())
                .carrierNameOther(getCarrierNameOther())
                .notifyPayer(getNotifyPayer())
                .items(getItems());
        return builder;
    }

    /**
     * Class to build instances of {@link OrderTrackerRequest}.
     */
    public static class Builder {
        private String captureId;
        private String trackingNumber;
        private ShipmentCarrier carrier;
        private String carrierNameOther;
        private Boolean notifyPayer = false;
        private List<OrderTrackerItem> items;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  captureId  String value for captureId.
         */
        public Builder(String captureId) {
            this.captureId = captureId;
        }

        /**
         * Setter for captureId.
         * @param  captureId  String value for captureId.
         * @return Builder
         */
        public Builder captureId(String captureId) {
            this.captureId = captureId;
            return this;
        }

        /**
         * Setter for trackingNumber.
         * @param  trackingNumber  String value for trackingNumber.
         * @return Builder
         */
        public Builder trackingNumber(String trackingNumber) {
            this.trackingNumber = trackingNumber;
            return this;
        }

        /**
         * Setter for carrier.
         * @param  carrier  ShipmentCarrier value for carrier.
         * @return Builder
         */
        public Builder carrier(ShipmentCarrier carrier) {
            this.carrier = carrier;
            return this;
        }

        /**
         * Setter for carrierNameOther.
         * @param  carrierNameOther  String value for carrierNameOther.
         * @return Builder
         */
        public Builder carrierNameOther(String carrierNameOther) {
            this.carrierNameOther = carrierNameOther;
            return this;
        }

        /**
         * Setter for notifyPayer.
         * @param  notifyPayer  Boolean value for notifyPayer.
         * @return Builder
         */
        public Builder notifyPayer(Boolean notifyPayer) {
            this.notifyPayer = notifyPayer;
            return this;
        }

        /**
         * Setter for items.
         * @param  items  List of OrderTrackerItem value for items.
         * @return Builder
         */
        public Builder items(List<OrderTrackerItem> items) {
            this.items = items;
            return this;
        }

        /**
         * Builds a new {@link OrderTrackerRequest} object using the set fields.
         * @return {@link OrderTrackerRequest}
         */
        public OrderTrackerRequest build() {
            return new OrderTrackerRequest(captureId, trackingNumber, carrier, carrierNameOther,
                    notifyPayer, items);
        }
    }
}
