/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;

/**
 * This is a model class for PhoneWithType type.
 */
public class PhoneWithType {
    private PhoneType phoneType;
    private PhoneNumber phoneNumber;

    /**
     * Default constructor.
     */
    public PhoneWithType() {
    }

    /**
     * Initialization constructor.
     * @param  phoneNumber  PhoneNumber value for phoneNumber.
     * @param  phoneType  PhoneType value for phoneType.
     */
    public PhoneWithType(
            PhoneNumber phoneNumber,
            PhoneType phoneType) {
        this.phoneType = phoneType;
        this.phoneNumber = phoneNumber;
    }

    /**
     * Getter for PhoneType.
     * The phone type.
     * @return Returns the PhoneType
     */
    @JsonGetter("phone_type")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public PhoneType getPhoneType() {
        return phoneType;
    }

    /**
     * Setter for PhoneType.
     * The phone type.
     * @param phoneType Value for PhoneType
     */
    @JsonSetter("phone_type")
    public void setPhoneType(PhoneType phoneType) {
        this.phoneType = phoneType;
    }

    /**
     * Getter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @return Returns the PhoneNumber
     */
    @JsonGetter("phone_number")
    public PhoneNumber getPhoneNumber() {
        return phoneNumber;
    }

    /**
     * Setter for PhoneNumber.
     * The phone number in its canonical international [E.164 numbering plan
     * format](https://www.itu.int/rec/T-REC-E.164/en).
     * @param phoneNumber Value for PhoneNumber
     */
    @JsonSetter("phone_number")
    public void setPhoneNumber(PhoneNumber phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /**
     * Converts this PhoneWithType into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "PhoneWithType [" + "phoneNumber=" + phoneNumber + ", phoneType=" + phoneType + "]";
    }

    /**
     * Builds a new {@link PhoneWithType.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link PhoneWithType.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(phoneNumber)
                .phoneType(getPhoneType());
        return builder;
    }

    /**
     * Class to build instances of {@link PhoneWithType}.
     */
    public static class Builder {
        private PhoneNumber phoneNumber;
        private PhoneType phoneType;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  phoneNumber  PhoneNumber value for phoneNumber.
         */
        public Builder(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
        }

        /**
         * Setter for phoneNumber.
         * @param  phoneNumber  PhoneNumber value for phoneNumber.
         * @return Builder
         */
        public Builder phoneNumber(PhoneNumber phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        /**
         * Setter for phoneType.
         * @param  phoneType  PhoneType value for phoneType.
         * @return Builder
         */
        public Builder phoneType(PhoneType phoneType) {
            this.phoneType = phoneType;
            return this;
        }

        /**
         * Builds a new {@link PhoneWithType} object using the set fields.
         * @return {@link PhoneWithType}
         */
        public PhoneWithType build() {
            return new PhoneWithType(phoneNumber, phoneType);
        }
    }
}
