/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

package com.paypal.sdk.models;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.util.List;

/**
 * This is a model class for UpdateOrderTrackingInput type.
 */
public class UpdateOrderTrackingInput {
    private String id;
    private String trackerId;
    private String contentType;
    private String paypalAuthAssertion;
    private List<Patch> body;

    /**
     * Default constructor.
     */
    public UpdateOrderTrackingInput() {
        contentType = "application/json";
    }

    /**
     * Initialization constructor.
     * @param  id  String value for id.
     * @param  trackerId  String value for trackerId.
     * @param  contentType  String value for contentType.
     * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
     * @param  body  List of Patch value for body.
     */
    public UpdateOrderTrackingInput(
            String id,
            String trackerId,
            String contentType,
            String paypalAuthAssertion,
            List<Patch> body) {
        this.id = id;
        this.trackerId = trackerId;
        this.contentType = contentType;
        this.paypalAuthAssertion = paypalAuthAssertion;
        this.body = body;
    }

    /**
     * Getter for Id.
     * The ID of the order that the tracking information is associated with.
     * @return Returns the String
     */
    @JsonGetter("id")
    public String getId() {
        return id;
    }

    /**
     * Setter for Id.
     * The ID of the order that the tracking information is associated with.
     * @param id Value for String
     */
    @JsonSetter("id")
    public void setId(String id) {
        this.id = id;
    }

    /**
     * Getter for TrackerId.
     * The order tracking ID.
     * @return Returns the String
     */
    @JsonGetter("tracker_id")
    public String getTrackerId() {
        return trackerId;
    }

    /**
     * Setter for TrackerId.
     * The order tracking ID.
     * @param trackerId Value for String
     */
    @JsonSetter("tracker_id")
    public void setTrackerId(String trackerId) {
        this.trackerId = trackerId;
    }

    /**
     * Getter for ContentType.
     * @return Returns the String
     */
    @JsonGetter("Content-Type")
    public String getContentType() {
        return contentType;
    }

    /**
     * Setter for ContentType.
     * @param contentType Value for String
     */
    @JsonSetter("Content-Type")
    private void setContentType(String contentType) {
        this.contentType = contentType;
    }

    /**
     * Getter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @return Returns the String
     */
    @JsonGetter("PayPal-Auth-Assertion")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public String getPaypalAuthAssertion() {
        return paypalAuthAssertion;
    }

    /**
     * Setter for PaypalAuthAssertion.
     * An API-caller-provided JSON Web Token (JWT) assertion that identifies the merchant. For
     * details, see PayPal-Auth-Assertion.
     * @param paypalAuthAssertion Value for String
     */
    @JsonSetter("PayPal-Auth-Assertion")
    public void setPaypalAuthAssertion(String paypalAuthAssertion) {
        this.paypalAuthAssertion = paypalAuthAssertion;
    }

    /**
     * Getter for Body.
     * @return Returns the List of Patch
     */
    @JsonGetter("body")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public List<Patch> getBody() {
        return body;
    }

    /**
     * Setter for Body.
     * @param body Value for List of Patch
     */
    @JsonSetter("body")
    public void setBody(List<Patch> body) {
        this.body = body;
    }

    /**
     * Converts this UpdateOrderTrackingInput into string format.
     * @return String representation of this class
     */
    @Override
    public String toString() {
        return "UpdateOrderTrackingInput [" + "id=" + id + ", trackerId=" + trackerId
                + ", contentType=" + contentType + ", paypalAuthAssertion=" + paypalAuthAssertion
                + ", body=" + body + "]";
    }

    /**
     * Builds a new {@link UpdateOrderTrackingInput.Builder} object.
     * Creates the instance with the state of the current model.
     * @return a new {@link UpdateOrderTrackingInput.Builder} object
     */
    public Builder toBuilder() {
        Builder builder = new Builder(id, trackerId, contentType)
                .paypalAuthAssertion(getPaypalAuthAssertion())
                .body(getBody());
        return builder;
    }

    /**
     * Class to build instances of {@link UpdateOrderTrackingInput}.
     */
    public static class Builder {
        private String id;
        private String trackerId;
        private String contentType = "application/json";
        private String paypalAuthAssertion;
        private List<Patch> body;

        /**
         * Initialization constructor.
         */
        public Builder() {
        }

        /**
         * Initialization constructor.
         * @param  id  String value for id.
         * @param  trackerId  String value for trackerId.
         * @param  contentType  String value for contentType.
         */
        public Builder(String id, String trackerId, String contentType) {
            this.id = id;
            this.trackerId = trackerId;
            this.contentType = contentType;
        }

        /**
         * Setter for id.
         * @param  id  String value for id.
         * @return Builder
         */
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        /**
         * Setter for trackerId.
         * @param  trackerId  String value for trackerId.
         * @return Builder
         */
        public Builder trackerId(String trackerId) {
            this.trackerId = trackerId;
            return this;
        }

        /**
         * Setter for contentType.
         * @param  contentType  String value for contentType.
         * @return Builder
         */
        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        /**
         * Setter for paypalAuthAssertion.
         * @param  paypalAuthAssertion  String value for paypalAuthAssertion.
         * @return Builder
         */
        public Builder paypalAuthAssertion(String paypalAuthAssertion) {
            this.paypalAuthAssertion = paypalAuthAssertion;
            return this;
        }

        /**
         * Setter for body.
         * @param  body  List of Patch value for body.
         * @return Builder
         */
        public Builder body(List<Patch> body) {
            this.body = body;
            return this;
        }

        /**
         * Builds a new {@link UpdateOrderTrackingInput} object using the set fields.
         * @return {@link UpdateOrderTrackingInput}
         */
        public UpdateOrderTrackingInput build() {
            return new UpdateOrderTrackingInput(id, trackerId, contentType, paypalAuthAssertion,
                    body);
        }
    }
}
