/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble.mockrxandroidble;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.polidea.rxandroidble.RxBleClient;
import com.polidea.rxandroidble.RxBleDevice;
import com.polidea.rxandroidble.RxBleDeviceServices;
import com.polidea.rxandroidble.RxBleScanResult;
import com.polidea.rxandroidble.mockrxandroidble.RxBleDeviceMock;
import com.polidea.rxandroidble.scan.ScanFilter;
import com.polidea.rxandroidble.scan.ScanResult;
import com.polidea.rxandroidble.scan.ScanSettings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import rx.Observable;
import rx.functions.Func1;
import rx.subjects.ReplaySubject;

public class RxBleClientMock
extends RxBleClient {
    private Set<RxBleDevice> bondedDevices;
    private ReplaySubject<RxBleDeviceMock> discoveredDevicesSubject;

    private RxBleClientMock(Builder builder) {
        this.bondedDevices = builder.bondedDevices;
        this.discoveredDevicesSubject = builder.discoverableDevicesSubject;
    }

    public RxBleDevice getBleDevice(final @NonNull String macAddress) {
        RxBleDevice rxBleDevice = (RxBleDevice)this.discoveredDevicesSubject.first((Func1)new Func1<RxBleDeviceMock, Boolean>(){

            public Boolean call(RxBleDeviceMock device) {
                return device.getMacAddress().equals(macAddress);
            }
        }).toBlocking().first();
        if (rxBleDevice == null) {
            throw new IllegalStateException("Mock is not configured for a given mac address. Use Builder#addDevice method.");
        }
        return rxBleDevice;
    }

    public Set<RxBleDevice> getBondedDevices() {
        return this.bondedDevices;
    }

    public Observable<RxBleScanResult> scanBleDevices(UUID ... filterServiceUUIDs) {
        return this.createScanOperation(filterServiceUUIDs);
    }

    private RxBleScanResult convertToPublicScanResult(RxBleDevice bleDevice, Integer rssi, byte[] scanRecord) {
        return new RxBleScanResult(bleDevice, rssi.intValue(), scanRecord);
    }

    @NonNull
    private Observable<RxBleScanResult> createScanOperation(final @Nullable UUID[] filterServiceUUIDs) {
        return this.discoveredDevicesSubject.filter((Func1)new Func1<RxBleDeviceMock, Boolean>(){

            public Boolean call(RxBleDeviceMock rxBleDevice) {
                return RxBleClientMock.this.filterDevice(rxBleDevice, filterServiceUUIDs);
            }
        }).map((Func1)new Func1<RxBleDeviceMock, RxBleScanResult>(){

            public RxBleScanResult call(RxBleDeviceMock rxBleDeviceMock) {
                return RxBleClientMock.this.createRxBleScanResult(rxBleDeviceMock);
            }
        });
    }

    @NonNull
    private RxBleScanResult createRxBleScanResult(RxBleDeviceMock rxBleDeviceMock) {
        return this.convertToPublicScanResult(rxBleDeviceMock, rxBleDeviceMock.getRssi(), rxBleDeviceMock.getScanRecord());
    }

    private boolean filterDevice(RxBleDevice rxBleDevice, @Nullable UUID[] filterServiceUUIDs) {
        if (filterServiceUUIDs == null || filterServiceUUIDs.length == 0) {
            return true;
        }
        List<UUID> advertisedUUIDs = ((RxBleDeviceMock)rxBleDevice).getAdvertisedUUIDs();
        for (UUID desiredUUID : filterServiceUUIDs) {
            if (advertisedUUIDs.contains(desiredUUID)) continue;
            return false;
        }
        return true;
    }

    public Observable<ScanResult> scanBleDevices(ScanSettings scanSettings, ScanFilter ... scanFilters) {
        return Observable.error((Throwable)new RuntimeException("not implemented"));
    }

    public Observable<RxBleClient.State> observeStateChanges() {
        return Observable.just((Object)RxBleClient.State.READY);
    }

    public RxBleClient.State getState() {
        return RxBleClient.State.READY;
    }

    public static class DescriptorsBuilder {
        private List<BluetoothGattDescriptor> bluetoothGattDescriptors = new ArrayList<BluetoothGattDescriptor>();

        public DescriptorsBuilder addDescriptor(@NonNull UUID uuid, @NonNull byte[] data) {
            BluetoothGattDescriptor bluetoothGattDescriptor = new BluetoothGattDescriptor(uuid, 0);
            bluetoothGattDescriptor.setValue(data);
            this.bluetoothGattDescriptors.add(bluetoothGattDescriptor);
            return this;
        }

        public List<BluetoothGattDescriptor> build() {
            return this.bluetoothGattDescriptors;
        }
    }

    public static class CharacteristicsBuilder {
        private List<BluetoothGattCharacteristic> bluetoothGattCharacteristics = new ArrayList<BluetoothGattCharacteristic>();

        public CharacteristicsBuilder addCharacteristic(@NonNull UUID uuid, @NonNull byte[] data, List<BluetoothGattDescriptor> descriptors) {
            BluetoothGattCharacteristic characteristic = new BluetoothGattCharacteristic(uuid, 0, 0);
            for (BluetoothGattDescriptor descriptor : descriptors) {
                characteristic.addDescriptor(descriptor);
            }
            characteristic.setValue(data);
            this.bluetoothGattCharacteristics.add(characteristic);
            return this;
        }

        public List<BluetoothGattCharacteristic> build() {
            return this.bluetoothGattCharacteristics;
        }
    }

    public static class DeviceBuilder {
        private int rssi = -1;
        private String deviceName;
        private String deviceMacAddress;
        private byte[] scanRecord;
        private RxBleDeviceServices rxBleDeviceServices = new RxBleDeviceServices(new ArrayList());
        private Map<UUID, Observable<byte[]>> characteristicNotificationSources = new HashMap<UUID, Observable<byte[]>>();

        public DeviceBuilder addService(@NonNull UUID uuid, @NonNull List<BluetoothGattCharacteristic> characteristics) {
            BluetoothGattService bluetoothGattService = new BluetoothGattService(uuid, 0);
            for (BluetoothGattCharacteristic characteristic : characteristics) {
                bluetoothGattService.addCharacteristic(characteristic);
            }
            this.rxBleDeviceServices.getBluetoothGattServices().add(bluetoothGattService);
            return this;
        }

        public RxBleDevice build() {
            if (this.rssi == -1) {
                throw new IllegalStateException("Rssi is required. DeviceBuilder#rssi should be called.");
            }
            if (this.deviceMacAddress == null) {
                throw new IllegalStateException("DeviceMacAddress required. DeviceBuilder#deviceMacAddress should be called.");
            }
            if (this.scanRecord == null) {
                throw new IllegalStateException("ScanRecord required. DeviceBuilder#scanRecord should be called.");
            }
            RxBleDeviceMock rxBleDeviceMock = new RxBleDeviceMock(this.deviceName, this.deviceMacAddress, this.scanRecord, this.rssi, this.rxBleDeviceServices, this.characteristicNotificationSources);
            for (BluetoothGattService service : this.rxBleDeviceServices.getBluetoothGattServices()) {
                rxBleDeviceMock.addAdvertisedUUID(service.getUuid());
            }
            return rxBleDeviceMock;
        }

        public DeviceBuilder deviceMacAddress(@NonNull String deviceMacAddress) {
            this.deviceMacAddress = deviceMacAddress;
            return this;
        }

        public DeviceBuilder deviceName(@NonNull String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public DeviceBuilder notificationSource(@NonNull UUID characteristicUUID, @NonNull Observable<byte[]> sourceObservable) {
            this.characteristicNotificationSources.put(characteristicUUID, sourceObservable);
            return this;
        }

        public DeviceBuilder rssi(int rssi) {
            this.rssi = rssi;
            return this;
        }

        public DeviceBuilder scanRecord(@NonNull byte[] scanRecord) {
            this.scanRecord = scanRecord;
            return this;
        }
    }

    public static class Builder {
        private ReplaySubject<RxBleDeviceMock> discoverableDevicesSubject = ReplaySubject.create();
        private Set<RxBleDevice> bondedDevices = new HashSet<RxBleDevice>();

        public Builder setDeviceDiscoveryObservable(@NonNull Observable<RxBleDeviceMock> discoverableDevicesObservable) {
            discoverableDevicesObservable.subscribe(this.discoverableDevicesSubject);
            return this;
        }

        public Builder addDevice(@NonNull RxBleDevice rxBleDevice) {
            this.discoverableDevicesSubject.onNext((Object)((RxBleDeviceMock)rxBleDevice));
            return this;
        }

        public Builder addBondedDevice(@NonNull RxBleDevice rxBleDevice) {
            this.bondedDevices.add(rxBleDevice);
            return this;
        }

        public RxBleClientMock build() {
            return new RxBleClientMock(this);
        }
    }
}

