/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble.mockrxandroidble;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.support.annotation.NonNull;
import com.polidea.rxandroidble.NotificationSetupMode;
import com.polidea.rxandroidble.RxBleConnection;
import com.polidea.rxandroidble.RxBleDeviceServices;
import com.polidea.rxandroidble.RxBleRadioOperationCustom;
import com.polidea.rxandroidble.exceptions.BleConflictingNotificationAlreadySetException;
import com.polidea.rxandroidble.internal.connection.ImmediateSerializedBatchAckStrategy;
import com.polidea.rxandroidble.internal.util.ObservableUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import rx.Completable;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Actions;
import rx.functions.Func1;

public class RxBleConnectionMock
implements RxBleConnection {
    private static final byte[] ENABLE_NOTIFICATION_VALUE = new byte[]{1, 0};
    private static final byte[] ENABLE_INDICATION_VALUE = new byte[]{2, 0};
    private static final byte[] DISABLE_NOTIFICATION_VALUE = new byte[]{0, 0};
    private static final UUID CLIENT_CHARACTERISTIC_CONFIG_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private HashMap<UUID, Observable<Observable<byte[]>>> notificationObservableMap = new HashMap();
    private HashMap<UUID, Observable<Observable<byte[]>>> indicationObservableMap = new HashMap();
    private RxBleDeviceServices rxBleDeviceServices;
    private int rssi;
    private int currentMtu = 23;
    private Map<UUID, Observable<byte[]>> characteristicNotificationSources;

    public RxBleConnectionMock(RxBleDeviceServices rxBleDeviceServices, int rssi, Map<UUID, Observable<byte[]>> characteristicNotificationSources) {
        this.rxBleDeviceServices = rxBleDeviceServices;
        this.rssi = rssi;
        this.characteristicNotificationSources = characteristicNotificationSources;
    }

    public Completable requestConnectionPriority(int connectionPriority, long delay, @NonNull TimeUnit timeUnit) {
        return Completable.timer((long)delay, (TimeUnit)timeUnit);
    }

    public Observable<Integer> requestMtu(final int mtu) {
        return Observable.fromCallable((Callable)new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                RxBleConnectionMock.this.currentMtu = mtu;
                return mtu;
            }
        });
    }

    public int getMtu() {
        return this.currentMtu;
    }

    public Observable<RxBleDeviceServices> discoverServices() {
        return Observable.just((Object)this.rxBleDeviceServices);
    }

    public Observable<RxBleDeviceServices> discoverServices(long timeout, @NonNull TimeUnit timeUnit) {
        return Observable.just((Object)this.rxBleDeviceServices);
    }

    public Observable<BluetoothGattCharacteristic> getCharacteristic(final @NonNull UUID characteristicUuid) {
        return this.discoverServices().flatMap((Func1)new Func1<RxBleDeviceServices, Observable<? extends BluetoothGattCharacteristic>>(){

            public Observable<? extends BluetoothGattCharacteristic> call(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getCharacteristic(characteristicUuid);
            }
        });
    }

    public Observable<byte[]> readCharacteristic(@NonNull UUID characteristicUuid) {
        return this.getCharacteristic(characteristicUuid).map((Func1)new Func1<BluetoothGattCharacteristic, byte[]>(){

            public byte[] call(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                return bluetoothGattCharacteristic.getValue();
            }
        });
    }

    public Observable<byte[]> readCharacteristic(@NonNull BluetoothGattCharacteristic characteristic) {
        return Observable.just((Object)characteristic.getValue());
    }

    public Observable<byte[]> readDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid) {
        return this.discoverServices().flatMap((Func1)new Func1<RxBleDeviceServices, Observable<BluetoothGattDescriptor>>(){

            public Observable<BluetoothGattDescriptor> call(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).map((Func1)new Func1<BluetoothGattDescriptor, byte[]>(){

            public byte[] call(BluetoothGattDescriptor bluetoothGattDescriptor) {
                return bluetoothGattDescriptor.getValue();
            }
        });
    }

    public Observable<byte[]> readDescriptor(@NonNull BluetoothGattDescriptor descriptor) {
        return Observable.just((Object)descriptor.getValue());
    }

    public Observable<Integer> readRssi() {
        return Observable.just((Object)this.rssi);
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull UUID characteristicUuid) {
        return this.setupNotification(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupNotification(characteristic, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupNotification(final @NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        if (this.indicationObservableMap.containsKey(characteristicUuid)) {
            return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristicUuid, true));
        }
        Observable<Observable<byte[]>> availableObservable = this.notificationObservableMap.get(characteristicUuid);
        if (availableObservable != null) {
            return availableObservable;
        }
        Observable newObservable = this.createCharacteristicNotificationObservable(characteristicUuid, setupMode, false).doOnUnsubscribe(new Action0(){

            public void call() {
                RxBleConnectionMock.this.dismissCharacteristicNotification(characteristicUuid, setupMode, false);
            }
        }).map((Func1)new Func1<Observable<byte[]>, Observable<byte[]>>(){

            public Observable<byte[]> call(Observable<byte[]> notificationDescriptorData) {
                return RxBleConnectionMock.this.observeOnCharacteristicChangeCallbacks(characteristicUuid);
            }
        }).replay(1).refCount();
        this.notificationObservableMap.put(characteristicUuid, (Observable<Observable<byte[]>>)newObservable);
        return newObservable;
    }

    public Observable<Observable<byte[]>> setupNotification(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.setupNotification(characteristic.getUuid(), setupMode);
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull UUID characteristicUuid) {
        return this.setupIndication(characteristicUuid, NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic) {
        return this.setupIndication(characteristic.getUuid(), NotificationSetupMode.DEFAULT);
    }

    public Observable<Observable<byte[]>> setupIndication(final @NonNull UUID characteristicUuid, final @NonNull NotificationSetupMode setupMode) {
        if (this.notificationObservableMap.containsKey(characteristicUuid)) {
            return Observable.error((Throwable)new BleConflictingNotificationAlreadySetException(characteristicUuid, false));
        }
        Observable<Observable<byte[]>> availableObservable = this.indicationObservableMap.get(characteristicUuid);
        if (availableObservable != null) {
            return availableObservable;
        }
        Observable newObservable = this.createCharacteristicNotificationObservable(characteristicUuid, setupMode, true).doOnUnsubscribe(new Action0(){

            public void call() {
                RxBleConnectionMock.this.dismissCharacteristicNotification(characteristicUuid, setupMode, true);
            }
        }).map((Func1)new Func1<Observable<byte[]>, Observable<byte[]>>(){

            public Observable<byte[]> call(Observable<byte[]> notificationDescriptorData) {
                return RxBleConnectionMock.this.observeOnCharacteristicChangeCallbacks(characteristicUuid);
            }
        }).replay(1).refCount();
        this.indicationObservableMap.put(characteristicUuid, (Observable<Observable<byte[]>>)newObservable);
        return newObservable;
    }

    public Observable<Observable<byte[]>> setupIndication(@NonNull BluetoothGattCharacteristic characteristic, @NonNull NotificationSetupMode setupMode) {
        return this.setupIndication(characteristic.getUuid(), setupMode);
    }

    public Observable<BluetoothGattCharacteristic> writeCharacteristic(final @NonNull BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        return this.getCharacteristic(bluetoothGattCharacteristic.getUuid()).map((Func1)new Func1<BluetoothGattCharacteristic, Boolean>(){

            public Boolean call(BluetoothGattCharacteristic characteristic) {
                return characteristic.setValue(bluetoothGattCharacteristic.getValue());
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<? extends BluetoothGattCharacteristic>>(){

            public Observable<? extends BluetoothGattCharacteristic> call(Boolean ignored) {
                return Observable.just((Object)bluetoothGattCharacteristic);
            }
        });
    }

    public Observable<byte[]> writeCharacteristic(@NonNull BluetoothGattCharacteristic bluetoothGattCharacteristic, @NonNull byte[] data) {
        bluetoothGattCharacteristic.setValue(data);
        return Observable.just((Object)data);
    }

    public RxBleConnection.LongWriteOperationBuilder createNewLongWriteBuilder() {
        return new RxBleConnection.LongWriteOperationBuilder(){
            private Observable<BluetoothGattCharacteristic> bluetoothGattCharacteristicObservable;
            private int maxBatchSize = 20;
            private byte[] bytes;
            private RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy = new ImmediateSerializedBatchAckStrategy();

            public RxBleConnection.LongWriteOperationBuilder setBytes(@NonNull byte[] bytes) {
                this.bytes = bytes;
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setCharacteristicUuid(final @NonNull UUID uuid) {
                this.bluetoothGattCharacteristicObservable = RxBleConnectionMock.this.discoverServices().flatMap((Func1)new Func1<RxBleDeviceServices, Observable<BluetoothGattCharacteristic>>(){

                    public Observable<BluetoothGattCharacteristic> call(RxBleDeviceServices rxBleDeviceServices) {
                        return rxBleDeviceServices.getCharacteristic(uuid);
                    }
                });
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setCharacteristic(@NonNull BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                this.bluetoothGattCharacteristicObservable = Observable.just((Object)bluetoothGattCharacteristic);
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setMaxBatchSize(int maxBatchSize) {
                this.maxBatchSize = maxBatchSize;
                return this;
            }

            public RxBleConnection.LongWriteOperationBuilder setWriteOperationAckStrategy(@NonNull RxBleConnection.WriteOperationAckStrategy writeOperationAckStrategy) {
                this.writeOperationAckStrategy = writeOperationAckStrategy;
                return this;
            }

            public Observable<byte[]> build() {
                if (this.bluetoothGattCharacteristicObservable == null) {
                    throw new IllegalArgumentException("setCharacteristicUuid() or setCharacteristic() needs to be called before build()");
                }
                if (this.bytes == null) {
                    throw new IllegalArgumentException("setBytes() needs to be called before build()");
                }
                boolean excess = this.bytes.length % this.maxBatchSize > 0;
                final AtomicInteger numberOfBatches = new AtomicInteger(this.bytes.length / this.maxBatchSize + (excess ? 1 : 0));
                return Observable.fromCallable((Callable)new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return numberOfBatches.get() > 0;
                    }
                }).compose((Observable.Transformer)this.writeOperationAckStrategy).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

                    public Observable<?> call(Observable<? extends Void> onWriteFinished) {
                        return onWriteFinished.takeWhile((Func1)new Func1<Void, Boolean>(){

                            public Boolean call(Void aVoid) {
                                return numberOfBatches.decrementAndGet() > 0;
                            }
                        });
                    }
                }).toCompletable().andThen(Observable.just((Object)this.bytes));
            }
        };
    }

    public Observable<byte[]> writeCharacteristic(@NonNull UUID characteristicUuid, final @NonNull byte[] data) {
        return this.getCharacteristic(characteristicUuid).map((Func1)new Func1<BluetoothGattCharacteristic, Boolean>(){

            public Boolean call(BluetoothGattCharacteristic characteristic) {
                return characteristic.setValue(data);
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<? extends byte[]>>(){

            public Observable<? extends byte[]> call(Boolean ignored) {
                return Observable.just((Object)data);
            }
        });
    }

    public Observable<byte[]> writeDescriptor(final @NonNull UUID serviceUuid, final @NonNull UUID characteristicUuid, final @NonNull UUID descriptorUuid, final @NonNull byte[] data) {
        return this.discoverServices().flatMap((Func1)new Func1<RxBleDeviceServices, Observable<BluetoothGattDescriptor>>(){

            public Observable<BluetoothGattDescriptor> call(RxBleDeviceServices rxBleDeviceServices) {
                return rxBleDeviceServices.getDescriptor(serviceUuid, characteristicUuid, descriptorUuid);
            }
        }).map((Func1)new Func1<BluetoothGattDescriptor, Boolean>(){

            public Boolean call(BluetoothGattDescriptor bluetoothGattDescriptor) {
                return bluetoothGattDescriptor.setValue(data);
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<? extends byte[]>>(){

            public Observable<? extends byte[]> call(Boolean ignored) {
                return Observable.just((Object)data);
            }
        });
    }

    public Observable<byte[]> writeDescriptor(final @NonNull BluetoothGattDescriptor descriptor, final @NonNull byte[] data) {
        return Completable.fromAction((Action0)new Action0(){

            public void call() {
                descriptor.setValue(data);
            }
        }).andThen(Observable.just((Object)data));
    }

    private Observable<Observable<byte[]>> createCharacteristicNotificationObservable(final UUID characteristicUuid, NotificationSetupMode setupMode, boolean isIndication) {
        return this.setupCharacteristicNotification(characteristicUuid, setupMode, true, isIndication).flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

            public Observable<Boolean> call(Boolean onNext) {
                return ObservableUtil.justOnNext((Object)onNext);
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<? extends Observable<byte[]>>>(){

            public Observable<? extends Observable<byte[]>> call(Boolean bluetoothGattDescriptorPair) {
                if (!RxBleConnectionMock.this.characteristicNotificationSources.containsKey(characteristicUuid)) {
                    return Observable.error((Throwable)new IllegalStateException("Lack of notification source for given characteristic"));
                }
                return Observable.just(RxBleConnectionMock.this.characteristicNotificationSources.get(characteristicUuid));
            }
        });
    }

    private void dismissCharacteristicNotification(UUID characteristicUuid, NotificationSetupMode setupMode, boolean isIndication) {
        this.notificationObservableMap.remove(characteristicUuid);
        this.setupCharacteristicNotification(characteristicUuid, setupMode, false, isIndication).subscribe((Action1)Actions.empty(), Actions.toAction1((Action0)Actions.empty()));
    }

    @NonNull
    private Observable<BluetoothGattDescriptor> getClientConfigurationDescriptor(UUID characteristicUuid) {
        return this.getCharacteristic(characteristicUuid).map((Func1)new Func1<BluetoothGattCharacteristic, BluetoothGattDescriptor>(){

            public BluetoothGattDescriptor call(BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                BluetoothGattDescriptor bluetoothGattDescriptor = bluetoothGattCharacteristic.getDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID);
                if (bluetoothGattDescriptor == null) {
                    bluetoothGattDescriptor = new BluetoothGattDescriptor(CLIENT_CHARACTERISTIC_CONFIG_UUID, 0);
                    bluetoothGattCharacteristic.addDescriptor(bluetoothGattDescriptor);
                }
                return bluetoothGattDescriptor;
            }
        });
    }

    @NonNull
    private Observable<byte[]> observeOnCharacteristicChangeCallbacks(UUID characteristicUuid) {
        return this.characteristicNotificationSources.get(characteristicUuid);
    }

    @NonNull
    private Observable<Boolean> setupCharacteristicNotification(UUID bluetoothGattCharacteristicUUID, NotificationSetupMode setupMode, final boolean enabled, boolean isIndication) {
        if (setupMode == NotificationSetupMode.DEFAULT) {
            final byte[] enableValue = isIndication ? ENABLE_INDICATION_VALUE : ENABLE_NOTIFICATION_VALUE;
            return this.getClientConfigurationDescriptor(bluetoothGattCharacteristicUUID).flatMap((Func1)new Func1<BluetoothGattDescriptor, Observable<byte[]>>(){

                public Observable<byte[]> call(BluetoothGattDescriptor bluetoothGattDescriptor) {
                    return RxBleConnectionMock.this.writeDescriptor(bluetoothGattDescriptor, enabled ? enableValue : DISABLE_NOTIFICATION_VALUE);
                }
            }).map((Func1)new Func1<byte[], Boolean>(){

                public Boolean call(byte[] ignored) {
                    return true;
                }
            });
        }
        return Observable.just((Object)true);
    }

    public <T> Observable<T> queue(@NonNull RxBleRadioOperationCustom<T> operation) {
        throw new UnsupportedOperationException("Mock does not support queuing custom operation.");
    }
}

