/*
 * Decompiled with CFR 0.152.
 */
package com.polidea.rxandroidble.mockrxandroidble;

import android.bluetooth.BluetoothDevice;
import android.content.Context;
import com.polidea.rxandroidble.RxBleConnection;
import com.polidea.rxandroidble.RxBleDevice;
import com.polidea.rxandroidble.RxBleDeviceServices;
import com.polidea.rxandroidble.exceptions.BleAlreadyConnectedException;
import com.polidea.rxandroidble.mockrxandroidble.RxBleConnectionMock;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.subjects.BehaviorSubject;

public class RxBleDeviceMock
implements RxBleDevice {
    private RxBleConnection rxBleConnection;
    private BehaviorSubject<RxBleConnection.RxBleConnectionState> connectionStateBehaviorSubject = BehaviorSubject.create((Object)RxBleConnection.RxBleConnectionState.DISCONNECTED);
    private String name;
    private String macAddress;
    private Integer rssi;
    private byte[] scanRecord;
    private List<UUID> advertisedUUIDs;
    private AtomicBoolean isConnected = new AtomicBoolean(false);

    public RxBleDeviceMock(String name, String macAddress, byte[] scanRecord, Integer rssi, RxBleDeviceServices rxBleDeviceServices, Map<UUID, Observable<byte[]>> characteristicNotificationSources) {
        this.name = name;
        this.macAddress = macAddress;
        this.rxBleConnection = new RxBleConnectionMock(rxBleDeviceServices, rssi, characteristicNotificationSources);
        this.rssi = rssi;
        this.scanRecord = scanRecord;
        this.advertisedUUIDs = new ArrayList<UUID>();
    }

    public void addAdvertisedUUID(UUID advertisedUUID) {
        this.advertisedUUIDs.add(advertisedUUID);
    }

    @Deprecated
    public Observable<RxBleConnection> establishConnection(Context context, boolean autoConnect) {
        return this.establishConnection(autoConnect);
    }

    public Observable<RxBleConnection> establishConnection(boolean autoConnect) {
        return Observable.defer((Func0)new Func0<Observable<RxBleConnection>>(){

            public Observable<RxBleConnection> call() {
                if (RxBleDeviceMock.this.isConnected.compareAndSet(false, true)) {
                    return RxBleDeviceMock.this.emitConnectionWithoutCompleting().doOnSubscribe(new Action0(){

                        public void call() {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.CONNECTING);
                        }
                    }).doOnNext((Action1)new Action1<RxBleConnection>(){

                        public void call(RxBleConnection rxBleConnection) {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.CONNECTED);
                        }
                    }).doOnUnsubscribe(new Action0(){

                        public void call() {
                            RxBleDeviceMock.this.connectionStateBehaviorSubject.onNext((Object)RxBleConnection.RxBleConnectionState.DISCONNECTED);
                            RxBleDeviceMock.this.isConnected.set(false);
                        }
                    });
                }
                return Observable.error((Throwable)new BleAlreadyConnectedException(RxBleDeviceMock.this.macAddress));
            }
        });
    }

    private Observable<RxBleConnection> emitConnectionWithoutCompleting() {
        return Observable.never().startWith((Object)this.rxBleConnection);
    }

    public List<UUID> getAdvertisedUUIDs() {
        return this.advertisedUUIDs;
    }

    public RxBleConnection.RxBleConnectionState getConnectionState() {
        return (RxBleConnection.RxBleConnectionState)this.observeConnectionStateChanges().toBlocking().first();
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public BluetoothDevice getBluetoothDevice() {
        throw new UnsupportedOperationException("Mock does not support returning a BluetoothDevice.");
    }

    public String getName() {
        return this.name;
    }

    public Integer getRssi() {
        return this.rssi;
    }

    public byte[] getScanRecord() {
        return this.scanRecord;
    }

    public Observable<RxBleConnection.RxBleConnectionState> observeConnectionStateChanges() {
        return this.connectionStateBehaviorSubject.distinctUntilChanged();
    }

    public String toString() {
        return "RxBleDeviceImpl{bluetoothDevice=" + this.name + '(' + this.macAddress + ')' + '}';
    }
}

