/*
 * Decompiled with CFR 0.152.
 */
package com.sankuai.inf.leaf.plugin;

import com.sankuai.inf.leaf.exception.InitException;
import com.sankuai.inf.leaf.plugin.LeafSpringBootProperties;
import com.sankuai.inf.leaf.service.SegmentService;
import com.sankuai.inf.leaf.service.SnowflakeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LeafSpringBootProperties.class})
public class LeafSpringBootStarterAutoConfigure {
    private Logger logger = LoggerFactory.getLogger(LeafSpringBootStarterAutoConfigure.class);
    @Autowired
    private LeafSpringBootProperties properties;

    @Bean
    public SegmentService initLeafSegmentStarter() throws Exception {
        if (this.properties != null && this.properties.getSegment() != null && this.properties.getSegment().isEnable()) {
            SegmentService segmentService = new SegmentService(this.properties.getSegment().getUrl(), this.properties.getSegment().getUsername(), this.properties.getSegment().getPassword());
            return segmentService;
        }
        this.logger.warn("init leaf segment ignore properties is {}", (Object)this.properties);
        return null;
    }

    @Bean
    public SnowflakeService initLeafSnowflakeStarter() throws InitException {
        if (this.properties != null && this.properties.getSnowflake() != null && this.properties.getSnowflake().isEnable()) {
            SnowflakeService snowflakeService = new SnowflakeService(this.properties.getSnowflake().getAddress(), this.properties.getSnowflake().getPort());
            return snowflakeService;
        }
        this.logger.warn("init leaf snowflake ignore properties is {}", (Object)this.properties);
        return null;
    }
}

