/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum BuildPlatform {
    Unknown(0),
    Darwinintel64(1),
    Hpia64(2),
    Linuxintel(3),
    Linuxppc64(4),
    Linuxppc64le(5),
    Linuxs390x(6),
    Linuxx86_64(7),
    Linuxx86_64_sles9(8),
    NTamd64(9),
    NTintel(10),
    Rs6000_64(11),
    Sun_64(12),
    Sunx86_64(13),
    Java(14);

    private static final BuildPlatform[] VALUES;

    public static BuildPlatform decode(int value) {
        return value >= 0 && value < VALUES.length ? VALUES[value] : Unknown;
    }

    public static String getDisplayName(int value) {
        return BuildPlatform.decode(value).name() + '(' + value + ')';
    }

    private BuildPlatform(int value) {
        if (value != this.ordinal()) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal();
    }

    static {
        VALUES = BuildPlatform.values();
    }
}

