/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbcext;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDBInterface;
import com.sap.db.jdbcext.wrapper.WrappedConnection;
import com.sap.db.util.JdbcObject;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

@ThreadSafe
public abstract class PooledConnectionSAP
extends JdbcObject
implements PooledConnection {
    @GuardedBy(value="itself")
    private final Set<ConnectionEventListener> _connectionEventListeners = new HashSet<ConnectionEventListener>();
    @GuardedBy(value="itself")
    private final Set<StatementEventListener> _statementEventListeners = new HashSet<StatementEventListener>();
    protected final ConnectionSapDB _physicalConnection;
    @GuardedBy(value="this")
    private WeakReference<PooledClientConnectionSapDB> _lastClientConnection;

    protected PooledConnectionSAP(Connection physicalConnection) {
        this._physicalConnection = (ConnectionSapDB)physicalConnection;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        return this._getConnection();
    }

    @Override
    public void close() throws SQLException {
        this._physicalConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            this._connectionEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            this._connectionEventListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            this._statementEventListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        if (listener == null) {
            return;
        }
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            this._statementEventListeners.remove(listener);
        }
    }

    public void reinitialize(ConnectionSapDB connection) throws SQLException {
        assert (this._physicalConnection.getBooleanConnectionProperty(ConnectionProperty.RETURN_TO_POOL_SETS_DEFAULTS));
        connection.reinitialize(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<StatementEventListener> _getStatementEventListeners() {
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            return Collections.unmodifiableSet(this._statementEventListeners);
        }
    }

    private Connection _getConnection() throws SQLException {
        PooledClientConnectionSapDB pcc;
        if (this._lastClientConnection != null && (pcc = (PooledClientConnectionSapDB)this._lastClientConnection.get()) != null) {
            pcc._close(false);
        }
        pcc = new PooledClientConnectionSapDB();
        this._lastClientConnection = new WeakReference<PooledClientConnectionSapDB>(pcc);
        return pcc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendConnectionClosed() {
        HashSet<ConnectionEventListener> temp;
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            if (this._connectionEventListeners.isEmpty()) {
                return;
            }
            temp = new HashSet<ConnectionEventListener>(this._connectionEventListeners);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this);
        for (ConnectionEventListener l : temp) {
            l.connectionClosed(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendConnectionError(SQLException e) {
        HashSet<ConnectionEventListener> temp;
        Set<ConnectionEventListener> set = this._connectionEventListeners;
        synchronized (set) {
            if (this._connectionEventListeners.isEmpty()) {
                return;
            }
            temp = new HashSet<ConnectionEventListener>(this._connectionEventListeners);
        }
        ConnectionEvent connectionEvent = new ConnectionEvent(this, e);
        for (ConnectionEventListener l : temp) {
            l.connectionErrorOccurred(connectionEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendStatementClosed(PreparedStatement ps) {
        HashSet<StatementEventListener> temp;
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            if (this._statementEventListeners.isEmpty()) {
                return;
            }
            temp = new HashSet<StatementEventListener>(this._statementEventListeners);
        }
        StatementEvent statementEvent = new StatementEvent(this, ps);
        for (StatementEventListener l : temp) {
            l.statementClosed(statementEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _sendStatementError(PreparedStatement ps, SQLException e) {
        HashSet<StatementEventListener> temp;
        Set<StatementEventListener> set = this._statementEventListeners;
        synchronized (set) {
            if (this._statementEventListeners.isEmpty()) {
                return;
            }
            temp = new HashSet<StatementEventListener>(this._statementEventListeners);
        }
        StatementEvent statementEvent = new StatementEvent(this, ps, e);
        for (StatementEventListener l : temp) {
            l.statementErrorOccurred(statementEvent);
        }
    }

    @ThreadSafe
    private class PooledClientConnectionSapDB
    extends WrappedConnection {
        private final AtomicBoolean _isClosed = new AtomicBoolean();

        private PooledClientConnectionSapDB() {
        }

        @Override
        public Connection getPhysicalConnection() {
            return PooledConnectionSAP.this._physicalConnection;
        }

        @Override
        public void sendConnectionErrorEvent(SQLException e) {
            boolean doSend;
            boolean bl = doSend = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).isConnectionReleasing() : true;
            if (doSend) {
                PooledConnectionSAP.this._sendConnectionError(e);
            }
        }

        @Override
        public void sendStatementErrorEvent(SQLException e, PreparedStatement ps) {
            boolean doSend;
            boolean bl = doSend = e instanceof SQLExceptionSapDBInterface ? ((SQLExceptionSapDBInterface)((Object)e)).isConnectionReleasing() : true;
            if (doSend) {
                PooledConnectionSAP.this._sendStatementError(ps, e);
            }
        }

        @Override
        public void sendStatementClosedEvent(PreparedStatement ps) {
            PooledConnectionSAP.this._sendStatementClosed(ps);
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this._isClosed.get() ? true : super.isClosed();
        }

        @Override
        public void close() throws SQLException {
            if (this._isClosed.get()) {
                return;
            }
            this._close(true);
        }

        private void _close(boolean sendConnectionClosed) throws SQLException {
            if (PooledConnectionSAP.this._physicalConnection.getBooleanConnectionProperty(ConnectionProperty.RETURN_TO_POOL_SETS_DEFAULTS)) {
                this._closeSetToDefaults(sendConnectionClosed);
            } else {
                this._closeSetToInitial(sendConnectionClosed);
            }
        }

        private void _closeSetToDefaults(boolean sendConnectionClosed) throws SQLException {
            ConnectionSapDB c;
            this.closeStatements();
            if (!this.getAutoCommit()) {
                this.rollback();
            }
            if ((c = ConnectionSapDB.getConnectionSapDB(PooledConnectionSAP.this._physicalConnection)) != null) {
                PooledConnectionSAP.this.reinitialize(c);
            }
            this._isClosed.set(true);
            if (sendConnectionClosed) {
                PooledConnectionSAP.this._sendConnectionClosed();
            }
        }

        private void _closeSetToInitial(boolean sendConnectionClosed) throws SQLException {
            this.closeStatements();
            if (!this._isClosed.get()) {
                PooledConnectionSAP.this._physicalConnection.returnToPool();
                this._isClosed.set(true);
            }
            if (sendConnectionClosed) {
                PooledConnectionSAP.this._sendConnectionClosed();
            }
        }
    }
}

