/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.StringUtils;
import com.sap.db.util.WindowsRegistryUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.sql.SQLException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

@ThreadSafe
public final class PlatformUtils {
    private static final boolean IS_WINDOWS;
    private static final boolean IS_LINUX;
    private static final boolean IS_AIX;
    private static final boolean IS_HPUX;
    private static final boolean IS_MACOS;
    private static final boolean IS_SUNOS;
    private static final boolean IS_ARM;
    private static final int DEFAULT_TIMEOUT = 10;
    private static final TimeUnit DEFAULT_TIMEOUT_UNITS;
    @GuardedBy(value="PlatformUtils.class")
    private static String _windowsSystemRoot;

    private PlatformUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static boolean isLinux() {
        return IS_LINUX;
    }

    public static boolean isAIX() {
        return IS_AIX;
    }

    public static boolean isHPUX() {
        return IS_HPUX;
    }

    public static boolean isMacOS() {
        return IS_MACOS;
    }

    public static boolean isSunOS() {
        return IS_SUNOS;
    }

    public static boolean isArm() {
        return IS_ARM;
    }

    public static Process exec(String command, String errorMessage) {
        return PlatformUtils._exec(command, false, errorMessage, 10, DEFAULT_TIMEOUT_UNITS);
    }

    public static Process exec(String command, boolean consumeInput, String errorMessage) {
        return PlatformUtils._exec(command, consumeInput, errorMessage, 10, DEFAULT_TIMEOUT_UNITS);
    }

    public static Process exec(String command, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        return PlatformUtils._exec(command, false, errorMessage, timeout, timeoutUnits);
    }

    public static Process execWindowsSystemExecutable(String executableName, String arguments, String errorMessage) {
        return PlatformUtils._execWindowsSystemExecutable(executableName, arguments, errorMessage, 10, DEFAULT_TIMEOUT_UNITS);
    }

    public static Process execWindowsSystemExecutable(String executableName, String arguments, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        return PlatformUtils._execWindowsSystemExecutable(executableName, arguments, errorMessage, timeout, timeoutUnits);
    }

    public static String getWindowsSystemRoot() {
        return PlatformUtils._getWindowsSystemRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getWindowsSID() {
        String errorMessage = "Can't get user SID";
        BufferedReader reader = null;
        try {
            String sid;
            Process process = PlatformUtils.execWindowsSystemExecutable("whoami.exe", "/user /fo csv /nh", errorMessage);
            reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                String string = null;
                return string;
            }
            String[] values = line.split(",");
            if (values.length < 2) {
                String string = null;
                return string;
            }
            String string = sid = StringUtils.unquote(values[1], '\"', '\u0000', true, false);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String getMachineName() throws UnknownHostException {
        String machineName = null;
        try {
            BufferedReader br = null;
            try {
                Process hostnameProc = PlatformUtils.exec("hostname", "hostname");
                if (hostnameProc.exitValue() == 0) {
                    br = new BufferedReader(new InputStreamReader(hostnameProc.getInputStream()));
                    machineName = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException hostnameProc) {}
                }
            }
        }
        catch (IOException | SecurityException br) {
            // empty catch block
        }
        if (machineName == null) {
            machineName = InetAddress.getLocalHost().getHostName();
            String ipString = "\\b\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\b";
            if (machineName.equals("localhost") || machineName.matches(ipString)) {
                throw new UnknownHostException(machineName);
            }
            int periodStart = machineName.indexOf(46);
            if (periodStart != -1) {
                machineName = machineName.substring(0, periodStart);
            }
        }
        return machineName;
    }

    public static String getSecureStoreUserProfilePath(String virtualHostName) throws SQLException {
        return PlatformUtils._getUserProfilePath(false, false, virtualHostName);
    }

    public static String getHdbkeystoreUserProfilePath() throws SQLException {
        return PlatformUtils._getUserProfilePath(true, true, null);
    }

    public static String getHdbkeystoreUserProfilePath(boolean create) throws SQLException {
        return PlatformUtils._getUserProfilePath(true, create, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Process _exec(String command, boolean consumeInput, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            boolean wasCompleted;
            process = runtime.exec(command);
            if (consumeInput) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                }
            }
            if (!(wasCompleted = process.waitFor(timeout, timeoutUnits))) {
                return process;
            }
            if (process.exitValue() == 0) return process;
        }
        catch (IOException | InterruptedException | SecurityException exception) {
            // empty catch block
        }
        return process;
    }

    private static Process _execWindowsSystemExecutable(String executableName, String arguments, String errorMessage, int timeout, TimeUnit timeoutUnits) {
        String systemRoot = PlatformUtils._getWindowsSystemRoot();
        String command = "\"" + (systemRoot != null && !systemRoot.isEmpty() ? systemRoot + "\\System32\\" : "") + executableName + "\" " + arguments;
        return PlatformUtils._exec(command, false, errorMessage, timeout, timeoutUnits);
    }

    private static synchronized String _getWindowsSystemRoot() {
        if (_windowsSystemRoot != null) {
            return _windowsSystemRoot;
        }
        if (Driver.getJavaVersion() <= 8) {
            _windowsSystemRoot = WindowsRegistryUtils.readString(-2147483646, "SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion", "SystemRoot");
            if (_windowsSystemRoot == null || _windowsSystemRoot.isEmpty()) {
                _windowsSystemRoot = System.getenv("SystemRoot");
            }
        } else {
            _windowsSystemRoot = System.getenv("SystemRoot");
        }
        if (_windowsSystemRoot == null) {
            _windowsSystemRoot = "";
        }
        return _windowsSystemRoot;
    }

    private static String _getUserProfilePath(boolean forHdbkeystore, boolean create, String virtualHostName) throws SQLException {
        String localMachine;
        StringBuilder profilePath = new StringBuilder();
        String hdbStorePath = System.getenv("HDB_USE_STORE_PATH");
        boolean haveHdbStorePath = hdbStorePath != null && !hdbStorePath.isEmpty();
        String hdbUseIdent = null;
        boolean haveHdbUseIdent = false;
        boolean haveVirtualHostName = virtualHostName != null && !virtualHostName.isEmpty();
        try {
            localMachine = PlatformUtils.getMachineName();
        }
        catch (UnknownHostException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.connection.securestoreunknownhost", new String[0]);
        }
        if (!forHdbkeystore) {
            hdbUseIdent = System.getenv("HDB_USE_IDENT");
            haveHdbUseIdent = PlatformUtils._isIdentValid(hdbUseIdent);
        }
        if (haveHdbStorePath) {
            if (haveHdbUseIdent) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoremultipleenvironmentidenterror", hdbStorePath, hdbUseIdent);
            }
            profilePath.append(hdbStorePath);
        } else if (PlatformUtils.isWindows()) {
            String allUsersDirectory = System.getenv("ALLUSERSPROFILE");
            if (allUsersDirectory == null || allUsersDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreallusersprofile", new String[0]);
            }
            profilePath.append(allUsersDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            if (haveHdbUseIdent) {
                profilePath.append(hdbUseIdent);
            } else if (localMachine.length() > 15) {
                profilePath.append(localMachine.substring(0, 15).toUpperCase(Locale.ENGLISH));
            } else {
                profilePath.append(localMachine);
            }
            profilePath.append(File.separatorChar);
            String sid = PlatformUtils.getWindowsSID();
            if (sid == null) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreunknownsid", new String[0]);
            }
            profilePath.append(sid);
        } else {
            if (haveVirtualHostName && haveHdbUseIdent) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestoreidenterror", virtualHostName, hdbUseIdent);
            }
            String homeDirectory = System.getenv("HOME");
            if (homeDirectory == null || homeDirectory.trim().isEmpty()) {
                throw SQLExceptionSapDB.newInstance("error.connection.securestorehomedirectory", new String[0]);
            }
            profilePath.append(homeDirectory);
            profilePath.append(File.separatorChar);
            profilePath.append(".hdb");
            profilePath.append(File.separatorChar);
            if (hdbUseIdent != null && !hdbUseIdent.isEmpty()) {
                profilePath.append(hdbUseIdent);
            } else if (haveVirtualHostName) {
                profilePath.append(virtualHostName);
            } else {
                profilePath.append(localMachine);
            }
        }
        if (create) {
            try {
                Files.createDirectories(Paths.get(profilePath.toString(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw SQLExceptionSapDB.newInstance((Throwable)e, "error.create.directory.failed", profilePath.toString(), e.getMessage());
            }
        }
        profilePath.append(File.separatorChar);
        return profilePath.toString();
    }

    private static boolean _isIdentValid(String hdbUseIdent) {
        if (hdbUseIdent == null || hdbUseIdent.trim().isEmpty()) {
            return false;
        }
        for (int i = 0; i < hdbUseIdent.length(); ++i) {
            char ch = hdbUseIdent.charAt(i);
            if (Character.isDigit(ch) || Character.isLetter(ch) || ch == '-' || ch == '_') continue;
            return false;
        }
        return true;
    }

    static {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        IS_WINDOWS = osName.contains("Windows");
        IS_LINUX = osName.contains("Linux");
        IS_AIX = osName.contains("AIX");
        IS_HPUX = osName.contains("HP");
        IS_MACOS = osName.contains("Mac");
        IS_SUNOS = osName.contains("SunOS");
        IS_ARM = osArch.contains("aarch64");
        DEFAULT_TIMEOUT_UNITS = TimeUnit.SECONDS;
    }
}

