/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.converters;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.converters.AbstractNumericConverter;
import com.sap.db.jdbc.converters.SQLParamController;
import com.sap.db.jdbc.packet.DataType;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.packet.ParameterMode;
import com.sap.db.jdbc.packet.ParameterOption;
import com.sap.db.util.ByteUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Set;

@ThreadSafe
class BooleanConverter
extends AbstractNumericConverter {
    protected BooleanConverter(ConnectionSapDB connection, Set<ParameterOption> parameterOptions, ParameterMode parameterMode, DataType dataType, int index, int inputFieldPos, int outputFieldPos, int length, int fraction, String schemaName, String tableName, String columnName, String columnLabel, boolean isEncrypted, ColumnEncryptionKey columnEncryptionKey, boolean isDeterministic) throws SQLException {
        super(connection, parameterOptions, parameterMode, dataType, index, inputFieldPos, outputFieldPos, length, fraction, schemaName, tableName, columnName, columnLabel, isEncrypted, columnEncryptionKey, isDeterministic);
    }

    @Override
    public int getEstimatedColumnSize() {
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(1) + 1;
        }
        return 1;
    }

    @Override
    protected int _getNonNullInputArgLength(Object data) throws SQLException {
        if (!(data instanceof Boolean)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        if (this._isEncrypted) {
            return this._cipher.getEncryptedLength(1) + 2;
        }
        return 2;
    }

    @Override
    protected int _putNonNullInputArg(HDataPart dataPart, Object data) throws SQLException {
        if (!(data instanceof Boolean)) {
            throw new AssertionError((Object)("Unexpected class for data: " + data.getClass().getCanonicalName()));
        }
        Boolean value = (Boolean)data;
        if (this._isEncrypted) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putBoolean(value, new byte[1], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putBooleanAsBoolean(value);
    }

    @Override
    protected int _getNullInputArgLength() {
        if (this._isEncrypted && !this._isDeterministic) {
            return this._cipher.getEncryptedLength(1) + 2;
        }
        return 1;
    }

    @Override
    protected int _putNullInputArg(HDataPart dataPart) throws SQLException {
        if (this._isEncrypted && !this._isDeterministic) {
            byte[] encrypted = this._getEncryptedBuffer(ByteUtils.putByte(1, new byte[1], 0));
            return dataPart.putEncryptedBytes(encrypted);
        }
        return dataPart.putNull(this._dataType);
    }

    @Override
    public int getColumnDisplaySize() {
        return 5;
    }

    @Override
    public Object getObject(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : Boolean.valueOf(this._getValueAsBoolean(controller, dataPart, false, decrypted, null));
    }

    @Override
    public boolean getBoolean(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true, null, outIsNull);
    }

    @Override
    public Boolean setBoolean(boolean value) throws SQLException {
        return value;
    }

    @Override
    public byte getByte(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (byte)(this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1 : 0);
    }

    @Override
    public Boolean setByte(byte value) throws SQLException {
        return value != 0;
    }

    @Override
    public short getShort(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return (short)(this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1 : 0);
    }

    @Override
    public Boolean setShort(short value) throws SQLException {
        return value != 0;
    }

    @Override
    public int getInt(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1 : 0;
    }

    @Override
    public Boolean setInt(int value) throws SQLException {
        return value != 0;
    }

    @Override
    public long getLong(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1L : 0L;
    }

    @Override
    public Boolean setLong(long value) throws SQLException {
        return value != 0L;
    }

    @Override
    public float getFloat(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1.0f : 0.0f;
    }

    @Override
    public Boolean setFloat(float value) throws SQLException {
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        return value != 0.0f;
    }

    @Override
    public double getDouble(SQLParamController controller, HDataPart dataPart, boolean[] outIsNull) throws SQLException {
        return this._getValueAsBoolean(controller, dataPart, true, null, outIsNull) ? 1.0 : 0.0;
    }

    @Override
    public Boolean setDouble(double value) throws SQLException {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            throw this._newSetNumericValueInvalidException(String.valueOf(value));
        }
        return value != 0.0;
    }

    @Override
    public BigDecimal getBigDecimal(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted;
        byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : (this._getValueAsBoolean(controller, dataPart, false, decrypted, null) ? BigDecimal.ONE : BigDecimal.ZERO);
    }

    @Override
    public Boolean setBigDecimal(BigDecimal value) throws SQLException {
        return value != null ? Boolean.valueOf(!value.equals(BigDecimal.ZERO)) : null;
    }

    @Override
    public String getString(SQLParamController controller, HDataPart dataPart) throws SQLException {
        byte[] decrypted;
        byte[] byArray = decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
        return dataPart.isNull(this, controller, decrypted) ? null : (this._getValueAsBoolean(controller, dataPart, false, decrypted, null) ? "1" : "0");
    }

    @Override
    public Boolean setString(String value) throws SQLException {
        if (value == null) {
            return null;
        }
        return this._normalizeBooleanString(value);
    }

    @Override
    public Boolean setBytes(byte[] value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value.length != 1) {
            throw this._newSetNumericInvalidByteArrayLengthConversionException(Arrays.toString(value));
        }
        return value[0] != 0;
    }

    private boolean _getValueAsBoolean(SQLParamController controller, HDataPart dataPart, boolean doNullCheck, byte[] decrypted, boolean[] outIsNull) throws SQLException {
        if (doNullCheck) {
            decrypted = this._isEncrypted && !this._isDeterministic ? this._getDecryptedBuffer(dataPart) : null;
            boolean isNull = dataPart.isNull(this, controller, decrypted);
            if (outIsNull != null) {
                outIsNull[0] = isNull;
            }
            if (isNull) {
                return false;
            }
        }
        if (this._isEncrypted) {
            if (decrypted == null) {
                decrypted = this._getDecryptedBuffer(dataPart);
            }
            return ByteUtils.getBoolean(decrypted, 0);
        }
        return dataPart.getBooleanAsBoolean();
    }

    private Boolean _normalizeBooleanString(String value) {
        String v = value.trim();
        if (v.equalsIgnoreCase("TRUE") || v.equals("1")) {
            return true;
        }
        if (v.equalsIgnoreCase("FALSE") || v.equals("0")) {
            return false;
        }
        if (v.equalsIgnoreCase("UNKNOWN")) {
            return null;
        }
        return Boolean.valueOf(v);
    }
}

