/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc.packet;

import com.sap.db.annotations.Immutable;

@Immutable
public enum DBConnectInfoOption {
    DatabaseName(1),
    Host(2),
    Port(3),
    OnCorrectDatabase(4),
    Unknown(-1);

    private static final DBConnectInfoOption[] VALUES;

    public static DBConnectInfoOption decode(int value) {
        return value >= 1 && value < VALUES.length ? VALUES[value - 1] : Unknown;
    }

    public static String getDisplayName(int value) {
        return DBConnectInfoOption.decode(value).name() + '(' + value + ')';
    }

    private DBConnectInfoOption(int value) {
        if (value != this.ordinal() + 1 && value != -1) {
            throw new AssertionError((Object)("Value/ordinal mismatch: value = " + value + "; ordinal = " + this.ordinal()));
        }
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    static {
        VALUES = DBConnectInfoOption.values();
    }
}

