/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.ConnectionProperties;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Driver;
import com.sap.db.jdbc.FetchInfo;
import com.sap.db.jdbc.HanaResultSet;
import com.sap.db.jdbc.HanaResultSetClean;
import com.sap.db.jdbc.HanaResultSetFinalize;
import com.sap.db.jdbc.HanaResultSetPhantom;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.StatementSapDB;
import com.sap.db.jdbc.packet.HDataPart;
import com.sap.db.jdbc.trace.TraceRecord;
import java.sql.SQLException;
import java.util.regex.Pattern;

@ThreadSafe
public interface StatementSapDB9Interface {
    default public String enquoteLiteral(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteLiteral") : null;
        try {
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteLiteral", string);
            }
            String string2 = "'" + string.replace("'", "''") + "'";
            if (bl) {
                statementSapDB._tracer.printResult(string2);
            }
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public String enquoteNCharLiteral(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "enquoteNCharLiteral") : null;
        try {
            if (bl) {
                statementSapDB._tracer.printCall(this, "enquoteNCharLiteral", string);
            }
            String string2 = "N'" + string.replace("'", "''") + "'";
            if (bl) {
                statementSapDB._tracer.printResult(string2);
            }
            String string3 = string2;
            return string3;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public String enquoteIdentifier(StatementSapDB statementSapDB, String string, boolean bl) throws SQLException {
        boolean bl2 = statementSapDB._tracer.on();
        boolean bl3 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl3 ? statementSapDB._newTraceRecord("Statement", "enquoteIdentifier") : null;
        try {
            Object object;
            int n;
            if (bl2) {
                statementSapDB._tracer.printCall(this, "enquoteIdentifier", string, bl);
            }
            if ((n = string.length()) < 1 || n > 127) {
                throw new SQLException("Invalid name");
            }
            if (Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches()) {
                object = bl ? "\"" + string + "\"" : string;
            } else {
                if (string.matches("^\".+\"$")) {
                    string = string.substring(1, n - 1);
                }
                if (Pattern.compile("[^\u0000\"]+").matcher(string).matches()) {
                    object = "\"" + string + "\"";
                } else {
                    throw new SQLException("Invalid name");
                }
            }
            if (bl2) {
                statementSapDB._tracer.printResult(object);
            }
            Object object2 = object;
            return object2;
        }
        catch (Throwable throwable) {
            if (bl2) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl3) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl3) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public boolean isSimpleIdentifier(StatementSapDB statementSapDB, String string) throws SQLException {
        boolean bl = statementSapDB._tracer.on();
        boolean bl2 = statementSapDB._tracer.pon();
        TraceRecord traceRecord = bl2 ? statementSapDB._newTraceRecord("Statement", "isSimpleIdentifier") : null;
        try {
            boolean bl3;
            boolean bl4;
            if (bl) {
                statementSapDB._tracer.printCall(this, "isSimpleIdentifier", string);
            }
            boolean bl5 = bl4 = (bl3 = string.length()) >= true && bl3 <= 127 != 0 && Pattern.compile("[\\p{Alpha}][\\p{Alnum}_]*").matcher(string).matches();
            if (bl) {
                statementSapDB._tracer.printResult(bl4);
            }
            bl3 = bl4;
            return bl3;
        }
        catch (Throwable throwable) {
            if (bl) {
                statementSapDB._tracer.printException(throwable);
            }
            if (bl2) {
                traceRecord.setException(throwable);
            }
            throw throwable;
        }
        finally {
            if (bl2) {
                statementSapDB._publish(traceRecord);
            }
        }
    }

    default public void _createResultSet(StatementSapDB statementSapDB, Session session, FetchInfo fetchInfo, boolean bl, HDataPart hDataPart, ConnectionProperties connectionProperties) throws SQLException {
        ConnectionSapDB connectionSapDB = statementSapDB._connection;
        if (Driver._createPhantomClass(connectionProperties)) {
            HanaResultSetPhantom.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createCleanerClass(connectionProperties)) {
            HanaResultSetClean.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else if (Driver._createFinalizerClass(connectionProperties)) {
            HanaResultSetFinalize.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        } else {
            HanaResultSet.newInstance(connectionSapDB.getTracer(), connectionSapDB, session, statementSapDB, fetchInfo, bl, hDataPart);
        }
    }
}

