/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.CursorID;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.converters.DataFormatDescription;
import com.sap.db.jdbc.packet.DataType;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@ThreadSafe
public class FetchInfo
implements DataFormatDescription {
    private final CursorID _cursorID;
    private final boolean _isTableOutputParameter;
    private final List<AbstractConverter> _converters;
    private final Map<String, AbstractConverter> _converterMap;
    private final boolean _hasLOB;
    private final int _estimatedRowSize;

    public FetchInfo(CursorID cursorID, boolean isTableOutputParameter, List<AbstractConverter> converters) {
        this._cursorID = cursorID;
        this._isTableOutputParameter = isTableOutputParameter;
        this._converters = converters;
        this._converterMap = new TreeMap<String, AbstractConverter>(String.CASE_INSENSITIVE_ORDER);
        boolean hasLOB = false;
        int estimatedRowSize = 0;
        for (AbstractConverter converter : this._converters) {
            hasLOB |= converter.isLOB();
            estimatedRowSize += converter.getEstimatedColumnSize();
            String columnLabel = converter.getColumnLabel();
            if (columnLabel == null || this._converterMap.containsKey(columnLabel)) continue;
            this._converterMap.put(columnLabel, converter);
        }
        this._hasLOB = hasLOB;
        this._estimatedRowSize = estimatedRowSize;
        for (AbstractConverter converter : this._converters) {
            String columnName = converter.getColumnName();
            if (columnName == null || this._converterMap.containsKey(columnName)) continue;
            this._converterMap.put(columnName, converter);
        }
    }

    @Override
    public int getOutputFieldCount() {
        return this._converters.size();
    }

    @Override
    public DataType getOutputFieldDataType(int outputFieldPos) {
        return this._converters.get(outputFieldPos - 1).getDataType();
    }

    @Override
    public boolean isOutputFieldEncrypted(int outputFieldPos) {
        return this._converters.get(outputFieldPos - 1).isEncrypted();
    }

    @Override
    public int getResultSetColumnCount() {
        return this._converters.size();
    }

    @Override
    public AbstractConverter getResultSetConverter(int columnIndex) {
        return this._converters.get(columnIndex - 1);
    }

    public CursorID getCursorID() {
        return this._cursorID;
    }

    public boolean isTableOutputParameter() {
        return this._isTableOutputParameter;
    }

    public AbstractConverter getResultSetConverter(String columnLabelOrName) {
        return this._converterMap.get(columnLabelOrName);
    }

    protected boolean _hasLOB() {
        return this._hasLOB;
    }

    protected int _getEstimatedRowSize() {
        return this._estimatedRowSize;
    }
}

