/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.jdbc;

import com.sap.db.annotations.ThreadSafe;
import com.sap.db.jdbc.WrapperDummy;
import com.sap.db.jdbc.converters.AbstractConverter;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.trace.Tracer;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.List;

@ThreadSafe
abstract class ParameterMetaDataSapDB
extends WrapperDummy
implements ParameterMetaData {
    private final Tracer _tracer;
    private final List<AbstractConverter> _converters;

    protected ParameterMetaDataSapDB(Tracer tracer, List<AbstractConverter> converters) {
        this._tracer = tracer;
        this._converters = converters;
    }

    @Override
    public int getParameterCount() throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterCount", new Object[0]);
            }
            int result = this._getParameterCount();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int isNullable(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isNullable", param);
            }
            int result = this._getConverter(param).isNullable();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "isSigned", param);
            }
            boolean result = this._getConverter(param).isSigned();
            if (on) {
                this._tracer.printResult(result);
            }
            boolean bl = result;
            return bl;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getPrecision", param);
            }
            int result = this._getConverter(param).getPrecision();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getScale(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getScale", param);
            }
            int result = this._getConverter(param).getScale();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterType", param);
            }
            int result = this._getConverter(param).getColumnType();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterTypeName", param);
            }
            String result = this._getConverter(param).getColumnTypeName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterClassName", param);
            }
            String result = this._getConverter(param).getColumnClassName();
            if (on) {
                this._tracer.printResult(result);
            }
            String string = result;
            return string;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        boolean on = this._tracer.on();
        try {
            if (on) {
                this._tracer.printCall(this, "getParameterMode", param);
            }
            int result = this._getConverter(param).getParameterMode().getValue();
            if (on) {
                this._tracer.printResult(result);
            }
            int n = result;
            return n;
        }
        catch (Throwable e) {
            if (on) {
                this._tracer.printException(e);
            }
            throw e;
        }
    }

    protected int _getParameterCount() throws SQLException {
        return this._converters.size();
    }

    private AbstractConverter _getConverter(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this._converters.size()) {
            throw SQLExceptionSapDB.newInstance("error.invalid.parameter.index", String.valueOf(parameterIndex));
        }
        return this._converters.get(parameterIndex - 1);
    }

    AbstractConverter getConverter(int parameterIndex) throws SQLException {
        return this._getConverter(parameterIndex);
    }
}

