/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.GuardedBy;
import com.sap.db.annotations.ThreadSafe;
import com.sap.db.util.Dbg;
import java.util.HashMap;
import java.util.Map;

@ThreadSafe
public class DbgInstanceCount {
    private static final int INSTANCE_DIGITS = 8;
    @GuardedBy(value="itself")
    private static final Map<String, Integer> INSTANCE_COUNTS;
    @GuardedBy(value="itself")
    private static final Map<String, Integer> CLEANED_COUNTS;
    private String _instanceClassName;
    private int _instanceNumber;
    private String _instanceString;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getInstanceCount(String key) {
        if (Dbg.runtimeEnabled) {
            Integer count;
            Map<String, Integer> map = INSTANCE_COUNTS;
            synchronized (map) {
                count = INSTANCE_COUNTS.get(key);
            }
            return count != null ? count : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCleanedCount(String key) {
        if (Dbg.runtimeEnabled) {
            Integer count;
            Map<String, Integer> map = CLEANED_COUNTS;
            synchronized (map) {
                count = CLEANED_COUNTS.get(key);
            }
            return count != null ? count : 0;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void incrementCleanedCount(String key) {
        if (Dbg.runtimeEnabled) {
            Map<String, Integer> map = CLEANED_COUNTS;
            synchronized (map) {
                Integer count = CLEANED_COUNTS.get(key);
                count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
                CLEANED_COUNTS.put(key, count);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCounts() {
        if (Dbg.runtimeEnabled) {
            Map<String, Integer> map = INSTANCE_COUNTS;
            synchronized (map) {
                INSTANCE_COUNTS.clear();
            }
            map = CLEANED_COUNTS;
            synchronized (map) {
                CLEANED_COUNTS.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbgInstanceCount() {
        if (Dbg.runtimeEnabled) {
            Integer instanceCount;
            String key = this.getClass().getSimpleName();
            Map<String, Integer> map = INSTANCE_COUNTS;
            synchronized (map) {
                instanceCount = INSTANCE_COUNTS.get(key);
                instanceCount = instanceCount == null ? Integer.valueOf(1) : Integer.valueOf(instanceCount + 1);
                INSTANCE_COUNTS.put(key, instanceCount);
            }
            this._instanceClassName = key;
            this._instanceNumber = instanceCount;
            this._instanceString = String.format("%1$8s", this._instanceNumber) + " : " + this._instanceClassName;
        }
    }

    public String getInstanceClassName() {
        return this._instanceClassName;
    }

    public int getInstanceNumber() {
        return this._instanceNumber;
    }

    public String getInstanceString() {
        return this._instanceString;
    }

    static {
        if (Dbg.runtimeEnabled) {
            INSTANCE_COUNTS = new HashMap<String, Integer>();
            CLEANED_COUNTS = new HashMap<String, Integer>();
        } else {
            INSTANCE_COUNTS = null;
            CLEANED_COUNTS = null;
        }
    }
}

