/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.prefs.Preferences;

@Immutable
public final class WindowsRegistryUtils {
    public static final int HKEY_CURRENT_USER = -2147483647;
    public static final int HKEY_LOCAL_MACHINE = -2147483646;
    private static final int REG_SUCCESS = 0;
    private static final int KEY_READ = 131097;
    private static final Preferences USER_ROOT = Preferences.userRoot();
    private static final Preferences SYSTEM_ROOT = Preferences.systemRoot();
    private static final Class<? extends Preferences> USER_CLASS = USER_ROOT.getClass();
    private static final Method REG_OPEN_KEY;
    private static final Method REG_CLOSE_KEY;
    private static final Method REG_QUERY_VALUE_EX;
    private static final boolean INIT_SUCCESS;

    private WindowsRegistryUtils() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    public static String readString(int hkey, String key, String valueName) {
        Preferences prefs;
        if (!INIT_SUCCESS) {
            return null;
        }
        if (hkey == -2147483646) {
            prefs = SYSTEM_ROOT;
        } else if (hkey == -2147483647) {
            prefs = USER_ROOT;
        } else {
            throw new AssertionError((Object)("Unexpected hkey: " + hkey));
        }
        return WindowsRegistryUtils._readString(prefs, hkey, key, valueName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String _readString(Preferences root, int hkey, String key, String valueName) {
        block17: {
            handles = null;
            try {
                handles = (int[])WindowsRegistryUtils.REG_OPEN_KEY.invoke((Object)root, new Object[]{hkey, WindowsRegistryUtils._toCstr(key), 131097});
                if (handles[1] == 0) ** GOTO lbl-1000
                var6_5 = null;
                if (handles == null) return var6_5;
                ** GOTO lbl19
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                block18: {
                    break block18;
                    catch (Throwable var9_15) {
                        if (handles == null) throw var9_15;
                        try {
                            WindowsRegistryUtils.REG_CLOSE_KEY.invoke((Object)root, new Object[]{(int)handles[0]});
                            throw var9_15;
                        }
                        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var10_16) {
                            // empty catch block
                        }
                        throw var9_15;
                    }
lbl19:
                    // 1 sources

                    try {
                        WindowsRegistryUtils.REG_CLOSE_KEY.invoke((Object)root, new Object[]{handles[0]});
                        return var6_5;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var7_9) {
                        // empty catch block
                    }
                    return var6_5;
                }
                var7_10 = null;
                if (handles == null) return var7_10;
                try {
                    WindowsRegistryUtils.REG_CLOSE_KEY.invoke((Object)root, new Object[]{(int)handles[0]});
                    return var7_10;
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var8_12) {
                    // empty catch block
                }
                return var7_10;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    byteValue = (byte[])WindowsRegistryUtils.REG_QUERY_VALUE_EX.invoke((Object)root, new Object[]{handles[0], WindowsRegistryUtils._toCstr(valueName)});
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    var7_11 = null;
                    if (handles == null) return var7_11;
                    try {
                        WindowsRegistryUtils.REG_CLOSE_KEY.invoke((Object)root, new Object[]{handles[0]});
                        return var7_11;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var8_13) {
                        // empty catch block
                    }
                    return var7_11;
                }
                if (handles == null) break block17;
            }
            try {
                WindowsRegistryUtils.REG_CLOSE_KEY.invoke((Object)root, new Object[]{handles[0]});
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException var6_8) {}
        }
        if (byteValue == null) return null;
        v0 = new String(byteValue).trim();
        return v0;
    }

    private static byte[] _toCstr(String str) {
        byte[] src = str.getBytes();
        int len = src.length;
        byte[] dst = new byte[len + 1];
        System.arraycopy(src, 0, dst, 0, len);
        return dst;
    }

    static {
        Method regOpenKey = null;
        Method regCloseKey = null;
        Method regQueryValueEx = null;
        boolean initSuccess = false;
        try {
            regOpenKey = USER_CLASS.getDeclaredMethod("WindowsRegOpenKey", Integer.TYPE, byte[].class, Integer.TYPE);
            regOpenKey.setAccessible(true);
            regCloseKey = USER_CLASS.getDeclaredMethod("WindowsRegCloseKey", Integer.TYPE);
            regCloseKey.setAccessible(true);
            regQueryValueEx = USER_CLASS.getDeclaredMethod("WindowsRegQueryValueEx", Integer.TYPE, byte[].class);
            regQueryValueEx.setAccessible(true);
            initSuccess = true;
        }
        catch (NoSuchMethodException | SecurityException exception) {
            // empty catch block
        }
        REG_OPEN_KEY = regOpenKey;
        REG_CLOSE_KEY = regCloseKey;
        REG_QUERY_VALUE_EX = regQueryValueEx;
        INIT_SUCCESS = initSuccess;
    }
}

