/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.google.common.base.Optional;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFacade;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import javax.servlet.http.HttpServletRequest;

public abstract class AbstractRequestContextFacade
implements RequestContextFacade {
    @Override
    public Optional<HttpServletRequest> getCurrentRequest() {
        Optional<RequestContext> currentRequestContext = this.getCurrentRequestContext();
        HttpServletRequest request = currentRequestContext.isPresent() ? (HttpServletRequest)((RequestContext)currentRequestContext.get()).getRequest().orNull() : null;
        return Optional.fromNullable(request);
    }

    @Override
    public <T> T getRequestContextProperty(String name, Class<T> type) throws RequestContextPropertyException {
        RequestContext currentRequestContext = (RequestContext)RequestContextAccessor.getCurrentRequestContext().orNull();
        if (currentRequestContext == null) {
            throw new RequestContextPropertyException("Failed to get property \"" + name + "\": no " + RequestContext.class.getSimpleName() + " available.");
        }
        Object property = currentRequestContext.getProperty(name).orNull();
        if (!type.isInstance(property)) {
            throw new RequestContextPropertyException("Failed to get object of type " + type.getName() + " from " + RequestContext.class.getSimpleName() + " property \"" + name + "\": " + (property == null ? "property is not present." : "property value has unexpected type " + property.getClass().getName() + ".") + " Have you correctly registered all required " + RequestContextListener.class.getSimpleName() + "s in the " + RequestContextServletFilter.class.getSimpleName() + "? This problem can also be caused by a preceding issue during the initialization of the " + "respective " + RequestContextListener.class.getSimpleName() + ". To analyze the root cause, increase the log level of the listener classes.");
        }
        Object result = property;
        return (T)result;
    }
}

