/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.logging.CloudLoggerFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextServletFilter;
import com.sap.cloud.sdk.cloudplatform.servlet.exception.RequestContextPropertyException;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.slf4j.Logger;

public abstract class AbstractRequestContextListener
implements RequestContextListener,
ServletContextListener {
    private static final Logger logger = CloudLoggerFactory.getLogger(AbstractRequestContextListener.class);

    protected abstract Map<String, Object> getProperties();

    @Override
    public void requestContextInitialized(RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking requestContextInitialized().");
        }
        Map<String, Object> properties = this.getProperties();
        try {
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                requestContext.setPropertyIfAbsent(entry.getKey(), entry.getValue());
            }
        }
        catch (RequestContextPropertyException e) {
            logger.error("Failed to initialize " + this.getClass().getSimpleName() + ".", (Throwable)e);
        }
    }

    @Override
    public void requestContextDestroyed(RequestContext requestContext) {
        if (logger.isDebugEnabled()) {
            logger.debug("Invoking requestContextDestroyed().");
        }
        Set<String> properties = this.getProperties().keySet();
        try {
            for (String property : properties) {
                requestContext.removeProperty(property);
            }
        }
        catch (RequestContextPropertyException e) {
            logger.error("Failed to destroy " + this.getClass().getSimpleName() + ".", (Throwable)e);
        }
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        RequestContextServletFilter.addDefaultListener(this);
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        RequestContextServletFilter.removeDefaultListener(this);
    }
}

