/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContext;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextAccessor;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextFactory;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestContextListener;
import java.util.PriorityQueue;
import java.util.concurrent.Callable;
import lombok.NonNull;

class RequestContextCallable<T>
implements Callable<T> {
    @NonNull
    private final RequestContext requestContext;
    private final PriorityQueue<RequestContextListener> requestContextListeners;
    private final Callable<T> callable;

    private void notifyContextInitialized() {
        for (RequestContextListener requestContextListener : this.requestContextListeners) {
            requestContextListener.requestContextInitialized(this.requestContext);
        }
    }

    private void notifyContextDestroyed() {
        PriorityQueue<RequestContextListener> reversed = new PriorityQueue<RequestContextListener>(this.requestContextListeners.size() + 1, RequestContextListener.reverseOrdering);
        reversed.addAll(this.requestContextListeners);
        for (RequestContextListener listener : reversed) {
            listener.requestContextDestroyed(this.requestContext);
        }
    }

    private void setCurrentContext(RequestContext requestContext) {
        if (RequestContextAccessor.getCurrentRequestContext().isPresent()) {
            throw new ShouldNotHappenException("Cannot set current context: " + RequestContext.class.getSimpleName() + " returned by " + RequestContextAccessor.getRequestContextFacade().getClass().getName() + " already initialized. Have you correctly configured the " + RequestContextFactory.class + "?");
        }
        RequestContextAccessor.getRequestContextFacade().setCurrentContext(requestContext);
    }

    private void removeCurrentContext() {
        if (!RequestContextAccessor.getCurrentRequestContext().isPresent()) {
            throw new ShouldNotHappenException("Cannot remove current context: " + RequestContext.class.getSimpleName() + " returned by " + RequestContextAccessor.getRequestContextFacade().getClass().getName() + " not initialized. Have you correctly configured the " + RequestContextFactory.class + "?");
        }
        RequestContextAccessor.getRequestContextFacade().removeCurrentContext();
    }

    @Override
    public T call() throws Exception {
        this.setCurrentContext(this.requestContext);
        try {
            T t;
            this.notifyContextInitialized();
            try {
                t = this.callable.call();
                this.notifyContextDestroyed();
            }
            catch (Throwable throwable) {
                this.notifyContextDestroyed();
                throw throwable;
            }
            return t;
        }
        finally {
            this.removeCurrentContext();
        }
    }

    public RequestContextCallable(@NonNull RequestContext requestContext, PriorityQueue<RequestContextListener> requestContextListeners, Callable<T> callable) {
        if (requestContext == null) {
            throw new NullPointerException("requestContext");
        }
        this.requestContext = requestContext;
        this.requestContextListeners = requestContextListeners;
        this.callable = callable;
    }
}

