/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.sqldelight;

import android.content.ContentValues;
import android.database.Cursor;
import com.squareup.sqldelight.ColumnAdapter;

public final class EnumColumnAdapter<T extends Enum<T>>
implements ColumnAdapter<T> {
    private final Class<T> cls;

    public static <T extends Enum<T>> EnumColumnAdapter<T> create(Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls == null");
        }
        return new EnumColumnAdapter<T>(cls);
    }

    private EnumColumnAdapter(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    public T map(Cursor cursor, int columnIndex) {
        if (cursor.isNull(columnIndex)) {
            return null;
        }
        return Enum.valueOf(this.cls, cursor.getString(columnIndex));
    }

    @Override
    public void marshal(ContentValues values, String key, T value) {
        values.put(key, value == null ? null : ((Enum)value).name());
    }
}

