/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.sqldelight;

import android.support.annotation.NonNull;
import com.squareup.sqldelight.ColumnAdapter;

public final class EnumColumnAdapter<T extends Enum<T>>
implements ColumnAdapter<T, String> {
    private final Class<T> cls;

    public static <T extends Enum<T>> EnumColumnAdapter<T> create(Class<T> cls) {
        if (cls == null) {
            throw new NullPointerException("cls == null");
        }
        return new EnumColumnAdapter<T>(cls);
    }

    private EnumColumnAdapter(Class<T> cls) {
        this.cls = cls;
    }

    @Override
    @NonNull
    public T decode(String databaseValue) {
        return Enum.valueOf(this.cls, databaseValue);
    }

    @Override
    public String encode(@NonNull T value) {
        return ((Enum)value).name();
    }
}

