/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.finagle.http;

import com.twitter.finagle.http.Cookie;
import com.twitter.finagle.http.CookieMap;
import com.twitter.finagle.http.HeaderMap;
import com.twitter.finagle.http.Message$;
import com.twitter.finagle.http.Method;
import com.twitter.finagle.http.Version;
import com.twitter.finagle.http.Version$;
import com.twitter.finagle.http.util.StringUtil$;
import com.twitter.io.Buf;
import com.twitter.io.Buf$;
import com.twitter.io.BufInputStream;
import com.twitter.util.Closable;
import com.twitter.util.Duration;
import com.twitter.util.Future;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Iterator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00115e!B\u0001\u0003\u0003\u0003Y!aB'fgN\fw-\u001a\u0006\u0003\u0007\u0011\tA\u0001\u001b;ua*\u0011QAB\u0001\bM&t\u0017m\u001a7f\u0015\t9\u0001\"A\u0004uo&$H/\u001a:\u000b\u0003%\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019a\u0014N\\5u}Q\tQ\u0003\u0005\u0002\u0017\u00015\t!\u0001\u0003\u0004\u0019\u0001\u0001\u0006K!G\u0001\t?\u000e|g\u000e^3oiB\u0011!$H\u0007\u00027)\u0011ADB\u0001\u0003S>L!AH\u000e\u0003\u0007\t+h\r\u0003\u0004!\u0001\u0001\u0006K!I\u0001\t?Z,'o]5p]B\u0011aCI\u0005\u0003G\t\u0011qAV3sg&|g\u000e\u0003\u0004&\u0001\u0001\u0006KAJ\u0001\t?\u000eDWO\\6fIB\u0011QbJ\u0005\u0003Q9\u0011qAQ8pY\u0016\fg\u000eC\u0003+\u0001\u0019\u00051&\u0001\u0004sK\u0006$WM]\u000b\u0002YA\u0011!$L\u0005\u0003]m\u0011aAU3bI\u0016\u0014\b\"\u0002\u0019\u0001\r\u0003\t\u0014AB<sSR,'/F\u00013%\r\u0019T\u0007\u000f\u0004\u0005i\u0001\u0001!G\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002\u001bm%\u0011qg\u0007\u0002\u0007/JLG/\u001a:\u0011\u0005ebT\"\u0001\u001e\u000b\u0005m2\u0011\u0001B;uS2L!!\u0010\u001e\u0003\u0011\rcwn]1cY\u0016DQa\u0010\u0001\u0007\u0002\u0001\u000b\u0011\"[:SKF,Xm\u001d;\u0016\u0003\u0019BQA\u0011\u0001\u0005\u0002\u0001\u000b!\"[:SKN\u0004xN\\:f\u0011\u0015!\u0005\u0001\"\u0001F\u0003\u001d\u0019wN\u001c;f]R,\u0012!\u0007\u0005\u0006\u000f\u0002!\t\u0001S\u0001\fG>tG/\u001a8u?\u0012*\u0017\u000f\u0006\u0002J\u0019B\u0011QBS\u0005\u0003\u0017:\u0011A!\u00168ji\")AI\u0012a\u00013!\u001aaIT-\u0011\u00075y\u0015+\u0003\u0002Q\u001d\t1A\u000f\u001b:poN\u0004\"AU,\u000e\u0003MS!\u0001V+\u0002\t1\fgn\u001a\u0006\u0002-\u0006!!.\u0019<b\u0013\tA6KA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c82\tyQVM \t\u00037\nt!\u0001\u00181\u0011\u0005usQ\"\u00010\u000b\u0005}S\u0011A\u0002\u001fs_>$h(\u0003\u0002b\u001d\u00051\u0001K]3eK\u001aL!a\u00193\u0003\rM#(/\u001b8h\u0015\t\tg\"M\u0003$M*L8.\u0006\u0002hQV\t!\fB\u0003j\u0015\t\u0007aNA\u0001U\u0013\tYG.A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003[:\ta\u0001\u001e5s_^\u001c\u0018CA8s!\ti\u0001/\u0003\u0002r\u001d\t9aj\u001c;iS:<\u0007CA:w\u001d\tiA/\u0003\u0002v\u001d\u00059\u0001/Y2lC\u001e,\u0017BA<y\u0005%!\u0006N]8xC\ndWM\u0003\u0002v\u001dE*1E_>}[:\u0011Qb_\u0005\u0003[:\tDAI\u0007\u000f{\n)1oY1mCF\u0012a%\u0015\u0005\u0007\t\u0002!)!!\u0001\u0015\t\u0005\r\u0011QA\u0007\u0002\u0001!)Ai a\u00013!\"qPTA\u0005c\u0019q\",a\u0003\u0002\u0012E21E\u001a6\u0002\u000e-\fda\t>|\u0003\u001fi\u0017\u0007\u0002\u0012\u000e\u001du\f$AJ)\t\u000f\u0005U\u0001\u0001\"\u0001\u0002\u0018\u00059a/\u001a:tS>tW#A\u0011\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e\u0005Ya/\u001a:tS>tw\fJ3r)\rI\u0015q\u0004\u0005\b\u0003+\tI\u00021\u0001\"\u0011\u001d\t)\u0002\u0001C\u0003\u0003G!B!a\u0001\u0002&!9\u0011QCA\u0011\u0001\u0004\t\u0003BBA\u0015\u0001\u0011\u0005\u0001)A\u0005jg\u000eCWO\\6fI\"9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0012AC:fi\u000eCWO\\6fIR\u0019\u0011*!\r\t\u000f\u0005M\u00121\u0006a\u0001M\u000591\r[;oW\u0016$\u0007bBA\u001c\u0001\u0019\u0005\u0011\u0011H\u0001\nQ\u0016\fG-\u001a:NCB,\"!a\u000f\u0011\u0007Y\ti$C\u0002\u0002@\t\u0011\u0011\u0002S3bI\u0016\u0014X*\u00199\t\u0015\u0005\r\u0003\u0001#b\u0001\n\u0003\t)%A\u0004d_>\\\u0017.Z:\u0016\u0005\u0005\u001d\u0003c\u0001\f\u0002J%\u0019\u00111\n\u0002\u0003\u0013\r{wn[5f\u001b\u0006\u0004\bbBA(\u0001\u0011\u0005\u0011\u0011K\u0001\u000bO\u0016$8i\\8lS\u0016\u001cHCAA*!\u0019\t)&!\u0017\u0002^5\u0011\u0011q\u000b\u0006\u0003wUKA!a\u0017\u0002X\tA\u0011\n^3sCR|'\u000fE\u0002\u0017\u0003?J1!!\u0019\u0003\u0005\u0019\u0019un\\6jK\"9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0014!C1eI\u000e{wn[5f)\rI\u0015\u0011\u000e\u0005\t\u0003W\n\u0019\u00071\u0001\u0002^\u000511m\\8lS\u0016Dq!a\u001c\u0001\t\u0003\t\t(\u0001\u0007sK6|g/Z\"p_.LW\rF\u0002J\u0003gBq!!\u001e\u0002n\u0001\u0007!,\u0001\u0003oC6,\u0007bBA=\u0001\u0011\u0005\u00111P\u0001\u0007C\u000e\u001cW\r\u001d;\u0016\u0005\u0005u\u0004#BA@\u0003\u000bSfbAAAi:\u0019Q,a!\n\u0003=I1!a\"y\u0005\r\u0019V-\u001d\u0005\b\u0003\u0017\u0003A\u0011AAG\u0003)\t7mY3qi~#S-\u001d\u000b\u0004\u0013\u0006=\u0005bBAI\u0003\u0013\u0003\rAW\u0001\u0006m\u0006dW/\u001a\u0005\b\u0003\u0017\u0003A\u0011AAK)\rI\u0015q\u0013\u0005\t\u00033\u000b\u0019\n1\u0001\u0002\u001c\u00061a/\u00197vKN\u0004R!a \u0002\u001ejK1!a(y\u0005!IE/\u001a:bE2,\u0007bBAR\u0001\u0011\u0005\u00111P\u0001\u0011C\u000e\u001cW\r\u001d;NK\u0012L\u0017\rV=qKNDq!a*\u0001\t\u0003\tI+A\u0003bY2|w/\u0006\u0002\u0002,B!Q\"!,[\u0013\r\tyK\u0004\u0002\u0007\u001fB$\u0018n\u001c8\t\u000f\u0005M\u0006\u0001\"\u0001\u00026\u0006I\u0011\r\u001c7po~#S-\u001d\u000b\u0004\u0013\u0006]\u0006bBAI\u0003c\u0003\rA\u0017\u0005\b\u0003g\u0003A\u0011AA^)\rI\u0015Q\u0018\u0005\t\u00033\u000bI\f1\u0001\u0002@B1\u0011qPAO\u0003\u0003\u00042AFAb\u0013\r\t)M\u0001\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000f\u0005%\u0007\u0001\"\u0001\u0002*\u0006i\u0011-\u001e;i_JL'0\u0019;j_:Dq!!4\u0001\t\u0003\ty-A\tbkRDwN]5{CRLwN\\0%KF$2!SAi\u0011\u001d\t\t*a3A\u0002iCq!!6\u0001\t\u0003\tI+\u0001\u0007dC\u000eDWmQ8oiJ|G\u000eC\u0004\u0002Z\u0002!\t!a7\u0002!\r\f7\r[3D_:$(o\u001c7`I\u0015\fHcA%\u0002^\"9\u0011\u0011SAl\u0001\u0004Q\u0006bBAm\u0001\u0011\u0005\u0011\u0011\u001d\u000b\u0004\u0013\u0006\r\b\u0002CAs\u0003?\u0004\r!a:\u0002\r5\f\u00070Q4f!\rI\u0014\u0011^\u0005\u0004\u0003WT$\u0001\u0003#ve\u0006$\u0018n\u001c8\t\u000f\u0005=\b\u0001\"\u0001\u0002*\u000691\r[1sg\u0016$\bbBAz\u0001\u0011\u0005\u0011Q_\u0001\fG\"\f'o]3u?\u0012*\u0017\u000fF\u0002J\u0003oDq!!%\u0002r\u0002\u0007!\fC\u0004\u0002|\u0002!\t!!@\u0002\u001b\r|g\u000e^3oi2+gn\u001a;i+\t\ty\u0010E\u0003\u000e\u0003[\u0013\t\u0001E\u0002\u000e\u0005\u0007I1A!\u0002\u000f\u0005\u0011auN\\4\t\u000f\t%\u0001\u0001\"\u0002\u0003\f\u0005\u00192m\u001c8uK:$H*\u001a8hi\"|%/\u00127tKR!!\u0011\u0001B\u0007\u0011!\u0011yAa\u0002A\u0002\t\u0005\u0011a\u00023fM\u0006,H\u000e\u001e\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0003E\u0019wN\u001c;f]RdUM\\4uQ~#S-\u001d\u000b\u0004\u0013\n]\u0001\u0002CAI\u0005#\u0001\rA!\u0001\t\u000f\u0005m\b\u0001\"\u0002\u0003\u001cQ!\u00111\u0001B\u000f\u0011!\t\tJ!\u0007A\u0002\t\u0005\u0001b\u0002B\u0011\u0001\u0011\u0005\u0011\u0011V\u0001\fG>tG/\u001a8u)f\u0004X\rC\u0004\u0003&\u0001!\tAa\n\u0002\u001f\r|g\u000e^3oiRK\b/Z0%KF$2!\u0013B\u0015\u0011\u001d\t\tJa\tA\u0002iCqA!\f\u0001\t\u0003\u0011y#\u0001\btKR\u001cuN\u001c;f]R$\u0016\u0010]3\u0015\u000b%\u0013\tD!\u000e\t\u000f\tM\"1\u0006a\u00015\u0006IQ.\u001a3jCRK\b/\u001a\u0005\n\u0003_\u0014Y\u0003%AA\u0002iCqA!\u000f\u0001\t\u0003\u0011Y$\u0001\ntKR\u001cuN\u001c;f]R$\u0016\u0010]3Kg>tG#A%\t\u000f\t}\u0002\u0001\"\u0001\u0002*\u0006!A-\u0019;f\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000b\n\u0001\u0002Z1uK~#S-\u001d\u000b\u0004\u0013\n\u001d\u0003bBAI\u0005\u0003\u0002\rA\u0017\u0005\b\u0005\u0007\u0002A\u0011\u0001B&)\rI%Q\n\u0005\t\u0003#\u0013I\u00051\u0001\u0003PA!\u0011Q\u000bB)\u0013\u0011\u0011\u0019&a\u0016\u0003\t\u0011\u000bG/\u001a\u0005\b\u0005/\u0002A\u0011AAU\u0003\u001d)\u0007\u0010]5sKNDqAa\u0017\u0001\t\u0003\u0011i&A\u0006fqBL'/Z:`I\u0015\fHcA%\u0003`!9\u0011\u0011\u0013B-\u0001\u0004Q\u0006b\u0002B.\u0001\u0011\u0005!1\r\u000b\u0004\u0013\n\u0015\u0004\u0002CAI\u0005C\u0002\rAa\u0014\t\u000f\t%\u0004\u0001\"\u0001\u0002*\u0006!\u0001n\\:u\u0011\u001d\u0011i\u0007\u0001C\u0001\u0005_\n\u0001\u0002[8ti~#S-\u001d\u000b\u0004\u0013\nE\u0004bBAI\u0005W\u0002\rA\u0017\u0005\b\u0005S\u0002AQ\u0001B;)\u0011\t\u0019Aa\u001e\t\u000f\u0005E%1\u000fa\u00015\"9!1\u0010\u0001\u0005\u0002\u0005%\u0016\u0001\u00047bgRlu\u000eZ5gS\u0016$\u0007b\u0002B@\u0001\u0011\u0005!\u0011Q\u0001\u0011Y\u0006\u001cH/T8eS\u001aLW\rZ0%KF$2!\u0013BB\u0011\u001d\t\tJ! A\u0002iCqAa \u0001\t\u0003\u00119\tF\u0002J\u0005\u0013C\u0001\"!%\u0003\u0006\u0002\u0007!q\n\u0005\b\u0005\u001b\u0003A\u0011AAU\u0003!awnY1uS>t\u0007b\u0002BI\u0001\u0011\u0005!1S\u0001\rY>\u001c\u0017\r^5p]~#S-\u001d\u000b\u0004\u0013\nU\u0005bBAI\u0005\u001f\u0003\rA\u0017\u0005\b\u0005g\u0001A\u0011AAU\u0011\u001d\u0011Y\n\u0001C\u0001\u0005;\u000bQ\"\\3eS\u0006$\u0016\u0010]3`I\u0015\fHcA%\u0003 \"9\u0011\u0011\u0013BM\u0001\u0004Q\u0006b\u0002BR\u0001\u0011\u0005\u0011\u0011V\u0001\be\u00164WM]3s\u0011\u001d\u00119\u000b\u0001C\u0001\u0005S\u000b1B]3gKJ,'o\u0018\u0013fcR\u0019\u0011Ja+\t\u000f\u0005E%Q\u0015a\u00015\"9!q\u0016\u0001\u0005\u0002\u0005%\u0016A\u0003:fiJL\u0018I\u001a;fe\"9!1\u0017\u0001\u0005\u0002\tU\u0016A\u0004:fiJL\u0018I\u001a;fe~#S-\u001d\u000b\u0004\u0013\n]\u0006bBAI\u0005c\u0003\rA\u0017\u0005\b\u0005g\u0003A\u0011\u0001B^)\rI%Q\u0018\u0005\t\u0003#\u0013I\f1\u0001\u0003\u0002!9!\u0011\u0019\u0001\u0005\u0002\u0005%\u0016AB:feZ,'\u000fC\u0004\u0003F\u0002!\tAa2\u0002\u0015M,'O^3s?\u0012*\u0017\u000fF\u0002J\u0005\u0013Dq!!%\u0003D\u0002\u0007!\fC\u0004\u0003N\u0002!\t!!+\u0002\u0013U\u001cXM]!hK:$\bb\u0002Bi\u0001\u0011\u0005!1[\u0001\u000ekN,'/Q4f]R|F%Z9\u0015\u0007%\u0013)\u000eC\u0004\u0002\u0012\n=\u0007\u0019\u0001.\t\u000f\te\u0007\u0001\"\u0001\u0002*\u0006yqo^<BkRDWM\u001c;jG\u0006$X\rC\u0004\u0003^\u0002!\tAa8\u0002']<x/Q;uQ\u0016tG/[2bi\u0016|F%Z9\u0015\u0007%\u0013\t\u000fC\u0004\u0002\u0012\nm\u0007\u0019\u0001.\t\u000f\t\u0015\b\u0001\"\u0001\u0002*\u0006i\u0001PR8so\u0006\u0014H-\u001a3G_JDqA!;\u0001\t\u0003\u0011Y/A\ty\r>\u0014x/\u0019:eK\u00124uN]0%KF$2!\u0013Bw\u0011\u001d\t\tJa:A\u0002iCaA!=\u0001\t\u0003\u0001\u0015\u0001E5t16d\u0007\n\u001e;q%\u0016\fX/Z:u\u0011\u001d\u0011)\u0010\u0001C\u0003\u0005o\fa\u0001\\3oORDWC\u0001B}!\ri!1`\u0005\u0004\u0005{t!aA%oi\"91\u0011\u0001\u0001\u0005\u0006\r\r\u0011!C4fi2+gn\u001a;i)\t\u0011I\u0010\u0003\u0004\u0004\b\u0001!\taZ\u0001\u000eG>tG/\u001a8u'R\u0014\u0018N\\4\t\u000f\r-\u0001\u0001\"\u0001\u0004\u000e\u0005\u0001r-\u001a;D_:$XM\u001c;TiJLgn\u001a\u000b\u00025\"91\u0011\u0003\u0001\u0005\u0002\rM\u0011!E2p]R,g\u000e^*ue&twm\u0018\u0013fcR\u0019\u0011j!\u0006\t\u000f\u0005E5q\u0002a\u00015\"91\u0011\u0004\u0001\u0005\u0006\rm\u0011\u0001E:fi\u000e{g\u000e^3oiN#(/\u001b8h)\rI5Q\u0004\u0005\b\u0003#\u001b9\u00021\u0001[\u0011\u001d\u0019\t\u0003\u0001C\u0001\u0007G\tqb^5uQ&s\u0007/\u001e;TiJ,\u0017-\\\u000b\u0005\u0007K\u0019Y\u0003\u0006\u0003\u0004(\rU\u0002\u0003BB\u0015\u0007Wa\u0001\u0001B\u0004j\u0007?\u0011\ra!\f\u0012\u0007=\u001cy\u0003E\u0002\u000e\u0007cI1aa\r\u000f\u0005\r\te.\u001f\u0005\t\u0007o\u0019y\u00021\u0001\u0004:\u0005\ta\rE\u0004\u000e\u0007w\u0019yda\n\n\u0007\rubBA\u0005Gk:\u001cG/[8ocA!1\u0011IB#\u001b\t\u0019\u0019E\u0003\u0002\u001d+&!1qIB\"\u0005-Ie\u000e];u'R\u0014X-Y7\t\u000f\r-\u0003\u0001\"\u0002\u0004N\u0005qq-\u001a;J]B,Ho\u0015;sK\u0006lGCAB \u0011\u001d\u0019\t\u0006\u0001C\u0003\u0007'\n!b^5uQJ+\u0017\rZ3s+\u0011\u0019)f!\u0017\u0015\t\r]31\f\t\u0005\u0007S\u0019I\u0006B\u0004j\u0007\u001f\u0012\ra!\f\t\u0011\r]2q\na\u0001\u0007;\u0002r!DB\u001e\u0007?\u001a9\u0006\u0005\u0003\u0004B\r\u0005\u0014b\u0001\u0018\u0004D!91Q\r\u0001\u0005\u0006\r\u001d\u0014!C4fiJ+\u0017\rZ3s)\t\u0019y\u0006C\u0004\u0004l\u0001!)a!\u001c\u0002\u000b]\u0014\u0018\u000e^3\u0015\u0007%\u001by\u0007C\u0004\u0004r\r%\u0004\u0019\u0001.\u0002\rM$(/\u001b8hQ\u0015\u0019IGTB;G\u0005\t\u0006bBB6\u0001\u0011\u00151\u0011\u0010\u000b\u0004\u0013\u000em\u0004bBB?\u0007o\u0002\r!G\u0001\u0004EV4\u0007&BB<\u001d\u000eU\u0004bBB6\u0001\u0011\u001511\u0011\u000b\u0004\u0013\u000e\u0015\u0005\u0002CBD\u0007\u0003\u0003\ra!#\u0002\u000b\tLH/Z:\u0011\u000b5\u0019Yia$\n\u0007\r5eBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0007#K1aa%\u000f\u0005\u0011\u0011\u0015\u0010^3)\u000b\r\u0005ej!\u001e\t\u000f\re\u0005\u0001\"\u0002\u0004\u001c\u0006\u0001r/\u001b;i\u001fV$\b/\u001e;TiJ,\u0017-\\\u000b\u0005\u0007;\u001b\t\u000b\u0006\u0003\u0004 \u000e\r\u0006\u0003BB\u0015\u0007C#q![BL\u0005\u0004\u0019i\u0003\u0003\u0005\u00048\r]\u0005\u0019ABS!\u001di11HBT\u0007?\u0003Ba!\u0011\u0004*&!11VB\"\u00051yU\u000f\u001e9viN#(/Z1nQ\u0015\u00199JTB;\u0011\u001d\u0019\t\f\u0001C\u0003\u0007g\u000b!b^5uQ^\u0013\u0018\u000e^3s+\u0011\u0019)l!/\u0015\t\r]61\u0018\t\u0005\u0007S\u0019I\fB\u0004j\u0007_\u0013\ra!\f\t\u0011\r]2q\u0016a\u0001\u0007{\u0003r!DB\u001e\u0007\u007f\u001b9\f\u0005\u0003\u0004B\r\u0005\u0017bA\u001c\u0004D!*1q\u0016(\u0004v!91q\u0019\u0001\u0005\u0006\tm\u0012\u0001D2mK\u0006\u00148i\u001c8uK:$\bbBBf\u0001\u0011\u00051QZ\u0001\u0006G2|7/\u001a\u000b\u0003\u0007\u001f\u0004B!OBi\u0013&\u001911\u001b\u001e\u0003\r\u0019+H/\u001e:f\u0011\u001d\u00199\u000e\u0001C\u0003\u00073\f\u0011b[3fa\u0006c\u0017N^3\u0015\t\u0005\r11\u001c\u0005\b\u0007/\u001c)\u000e1\u0001'\u0011\u0019\u00199\u000e\u0001C\u0003\u0001\"I1\u0011\u001d\u0001\u0012\u0002\u0013\u000511]\u0001\u0019g\u0016$8i\u001c8uK:$H+\u001f9fI\u0011,g-Y;mi\u0012\u0012TCABsU\rQ6q]\u0016\u0003\u0007S\u0004Baa;\u0004v6\u00111Q\u001e\u0006\u0005\u0007_\u001c\t0A\u0005v]\u000eDWmY6fI*\u001911\u001f\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0004x\u000e5(!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001e911 \u0002\t\u0002\ru\u0018aB'fgN\fw-\u001a\t\u0004-\r}hAB\u0001\u0003\u0011\u0003!\taE\u0002\u0004\u00002AqaEB\u0000\t\u0003!)\u0001\u0006\u0002\u0004~\u001a9A\u0011BB\u0000\r\u0011-!a\u0004\"vM>+H\u000f];u'R\u0014X-Y7\u0014\t\u0011\u001dAQ\u0002\t\u0005\u0007\u0003\"y!\u0003\u0003\u0005\u0012\r\r#!\u0006\"zi\u0016\f%O]1z\u001fV$\b/\u001e;TiJ,\u0017-\u001c\u0005\f\t+!9A!A!\u0002\u0013\u0011I0A\u0006j]&$\u0018.\u00197TSj,\u0007bB\n\u0005\b\u0011\u0005A\u0011\u0004\u000b\u0005\t7!y\u0002\u0005\u0003\u0005\u001e\u0011\u001dQBAB\u0000\u0011!!)\u0002b\u0006A\u0002\te\bb\u0002C\u0012\t\u000f!\t!R\u0001\u000eG>tG/\u001a8ug\u0006\u001b()\u001e4\t\u0017\u0011\u001d2q b\u0001\n\u0003\u0011A\u0011F\u0001\u0005+R4\u0007(\u0006\u0002\u0005,A!AQ\u0006C\u001b\u001b\t!yC\u0003\u0003\u0002p\u0012E\"b\u0001C\u001a+\u0006\u0019a.[8\n\t\u0011]Bq\u0006\u0002\b\u0007\"\f'o]3u\u0011%!Yda@!\u0002\u0013!Y#A\u0003Vi\u001aD\u0004\u0005\u0003\u0006\u0005@\r}(\u0019!C\u0001\t\u0003\n1b\u00115beN,G/\u0016;gqU\u0011A1\t\t\u0004%\u0012\u0015\u0013BA2T\u0011%!Iea@!\u0002\u0013!\u0019%\u0001\u0007DQ\u0006\u00148/\u001a;Vi\u001aD\u0004\u0005\u0003\u0006\u0005N\r}(\u0019!C\u0001\t\u0003\nqbQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c\u0005\n\t#\u001ay\u0010)A\u0005\t\u0007\n\u0001cQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c\u0011\t\u0015\u0011U3q b\u0001\n\u0003!\t%\u0001\u000bD_:$XM\u001c;UsB,'j]8o!\u0006$8\r\u001b\u0005\n\t3\u001ay\u0010)A\u0005\t\u0007\nQcQ8oi\u0016tG\u000fV=qK*\u001bxN\u001c)bi\u000eD\u0007\u0005\u0003\u0006\u0005^\r}(\u0019!C\u0001\t\u0003\nQcQ8oi\u0016tG\u000fV=qK*\u000bg/Y:de&\u0004H\u000fC\u0005\u0005b\r}\b\u0015!\u0003\u0005D\u000512i\u001c8uK:$H+\u001f9f\u0015\u00064\u0018m]2sSB$\b\u0005\u0003\u0006\u0005f\r}(\u0019!C\u0001\t\u0003\n!cQ8oi\u0016tG\u000fV=qK^;xOR8s[\"IA\u0011NB\u0000A\u0003%A1I\u0001\u0014\u0007>tG/\u001a8u)f\u0004XmV<x\r>\u0014X\u000e\t\u0005\u000b\t[\u001ayP1A\u0005\n\u0011=\u0014A\u0004%uiB$\u0015\r^3G_Jl\u0017\r^\u000b\u0003\tc\u0002B\u0001b\u001d\u0005~5\u0011AQ\u000f\u0006\u0005\to\"I(\u0001\u0004g_Jl\u0017\r\u001e\u0006\u0004\tw*\u0016\u0001\u0002;j[\u0016LA\u0001b \u0005v\t\tB)\u0019;f)&lWMR8s[\u0006$H/\u001a:\t\u0013\u0011\r5q Q\u0001\n\u0011E\u0014a\u0004%uiB$\u0015\r^3G_Jl\u0017\r\u001e\u0011\t\u0011\u0011\u001d5q C\u0001\t\u0013\u000ba\u0002\u001b;ua\u0012\u000bG/\u001a$pe6\fG\u000fF\u0002[\t\u0017C\u0001Ba\u0010\u0005\u0006\u0002\u0007!q\n")
public abstract class Message {
    private CookieMap cookies;
    private Buf _content = Buf$.MODULE$.Empty();
    private Version _version = Version$.MODULE$.Http11();
    private boolean _chunked = false;
    private volatile boolean bitmap$0;

    public static String httpDateFormat(Date date) {
        return Message$.MODULE$.httpDateFormat(date);
    }

    public static String ContentTypeWwwForm() {
        return Message$.MODULE$.ContentTypeWwwForm();
    }

    public static String ContentTypeJavascript() {
        return Message$.MODULE$.ContentTypeJavascript();
    }

    public static String ContentTypeJsonPatch() {
        return Message$.MODULE$.ContentTypeJsonPatch();
    }

    public static String ContentTypeJson() {
        return Message$.MODULE$.ContentTypeJson();
    }

    public static String CharsetUtf8() {
        return Message$.MODULE$.CharsetUtf8();
    }

    public abstract com.twitter.io.Reader reader();

    public abstract com.twitter.io.Writer writer();

    public abstract boolean isRequest();

    public boolean isResponse() {
        return !this.isRequest();
    }

    public Buf content() {
        return this._content;
    }

    public void content_$eq(Buf content) throws IllegalStateException {
        if (!content.isEmpty() && this.isChunked()) {
            throw new IllegalStateException("Cannot set content on Chunked message");
        }
        this._content = content;
    }

    public final Message content(Buf content) throws IllegalStateException {
        this.content_$eq(content);
        return this;
    }

    public Version version() {
        return this._version;
    }

    public void version_$eq(Version version) {
        this._version = version;
    }

    public final Message version(Version version) {
        this.version_$eq(version);
        return this;
    }

    public boolean isChunked() {
        return this._chunked;
    }

    public void setChunked(boolean chunked) {
        block0: {
            this._chunked = chunked;
            if (!chunked) break block0;
            this.clearContent();
        }
    }

    public abstract HeaderMap headerMap();

    private CookieMap cookies$lzycompute() {
        Message message = this;
        synchronized (message) {
            if (!this.bitmap$0) {
                this.cookies = new CookieMap(this);
                this.bitmap$0 = true;
            }
        }
        return this.cookies;
    }

    public CookieMap cookies() {
        return !this.bitmap$0 ? this.cookies$lzycompute() : this.cookies;
    }

    public Iterator<Cookie> getCookies() {
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(this.cookies().valuesIterator()).asJava();
    }

    public void addCookie(Cookie cookie) {
        this.cookies().$plus$eq(cookie);
    }

    public void removeCookie(String name) {
        this.cookies().$minus$eq(name);
    }

    public Seq<String> accept() {
        Seq seq;
        Option<String> option = this.headerMap().get("Accept");
        if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            seq = Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])s.split(","))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$accept$2(x$2))));
        } else if (None$.MODULE$.equals(option)) {
            seq = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        } else {
            throw new MatchError(option);
        }
        return seq;
    }

    public void accept_$eq(String value) {
        this.headerMap().set("Accept", value);
    }

    public void accept_$eq(Iterable<String> values) {
        this.accept_$eq(values.mkString(", "));
    }

    public Seq<String> acceptMediaTypes() {
        return (Seq)((GenericTraversableTemplate)this.accept().map((Function1 & Serializable & scala.Serializable)x$3 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])x$3.split(";", 2))).headOption().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.trim().toLowerCase()).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$acceptMediaTypes$3(x$5))), Seq$.MODULE$.canBuildFrom())).flatten((Function1 & Serializable & scala.Serializable)xo -> Option$.MODULE$.option2Iterable(xo));
    }

    public Option<String> allow() {
        return this.headerMap().get("Allow");
    }

    public void allow_$eq(String value) {
        this.headerMap().set("Allow", value);
    }

    public void allow_$eq(Iterable<Method> values) {
        this.allow_$eq(values.mkString(",").toUpperCase());
    }

    public Option<String> authorization() {
        return this.headerMap().get("Authorization");
    }

    public void authorization_$eq(String value) {
        this.headerMap().set("Authorization", value);
    }

    public Option<String> cacheControl() {
        return this.headerMap().get("Cache-Control");
    }

    public void cacheControl_$eq(String value) {
        this.headerMap().set("Cache-Control", value);
    }

    public void cacheControl_$eq(Duration maxAge) {
        this.cacheControl_$eq("max-age=" + ((Object)BoxesRunTime.boxToInteger((int)maxAge.inSeconds())).toString() + ", must-revalidate");
    }

    public Option<String> charset() {
        None$ none$;
        Object object = new Object();
        try {
            this.contentType().foreach((Function1 & Serializable & scala.Serializable)contentType -> {
                Message.$anonfun$charset$1(object, contentType);
                return BoxedUnit.UNIT;
            });
            none$ = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                none$ = (Option)ex.value();
            }
            throw ex;
        }
        return none$;
    }

    public void charset_$eq(String value) {
        String contentType = (String)this.contentType().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        if (parts.isEmpty()) {
            this.contentType_$eq(";charset=" + value);
            return;
        }
        StringBuilder builder = new StringBuilder((String)parts.apply(0));
        if (!parts.exists((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$charset_$eq$2(x$6)))) {
            builder.append(";charset=");
            builder.append(value);
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$3(parts, builder, BoxesRunTime.unboxToInt((Object)i)));
        } else {
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach((Function1 & Serializable & scala.Serializable)i -> Message.$anonfun$charset_$eq$4(value, parts, builder, BoxesRunTime.unboxToInt((Object)i)));
        }
        this.contentType_$eq(builder.toString());
    }

    public Option<Object> contentLength() {
        return this.headerMap().get("Content-Length").map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)Message.$anonfun$contentLength$1(x$7)));
    }

    public final long contentLengthOrElse(long l) {
        long l2;
        Option<Object> option = this.contentLength();
        if (option instanceof Some) {
            long len;
            Some some = (Some)option;
            l2 = len = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l2 = l;
        } else {
            throw new MatchError(option);
        }
        return l2;
    }

    public void contentLength_$eq(long value) {
        this.headerMap().set("Content-Length", ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public final Message contentLength(long value) {
        this.contentLength_$eq(value);
        return this;
    }

    public Option<String> contentType() {
        return this.headerMap().get("Content-Type");
    }

    public void contentType_$eq(String value) {
        this.headerMap().set("Content-Type", value);
    }

    public void setContentType(String mediaType, String charset) {
        this.headerMap().set("Content-Type", mediaType + ";charset=" + charset);
    }

    public String setContentType$default$2() {
        return "utf-8";
    }

    public void setContentTypeJson() {
        this.headerMap().set("Content-Type", Message$.MODULE$.ContentTypeJson());
    }

    public Option<String> date() {
        return this.headerMap().get("Date");
    }

    public void date_$eq(String value) {
        this.headerMap().set("Date", value);
    }

    public void date_$eq(Date value) {
        this.date_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> expires() {
        return this.headerMap().get("Expires");
    }

    public void expires_$eq(String value) {
        this.headerMap().set("Expires", value);
    }

    public void expires_$eq(Date value) {
        this.expires_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> host() {
        return this.headerMap().get("Host");
    }

    public void host_$eq(String value) {
        this.headerMap().set("Host", value);
    }

    public final Message host(String value) {
        this.host_$eq(value);
        return this;
    }

    public Option<String> lastModified() {
        return this.headerMap().get("Last-Modified");
    }

    public void lastModified_$eq(String value) {
        this.headerMap().set("Last-Modified", value);
    }

    public void lastModified_$eq(Date value) {
        this.lastModified_$eq(Message$.MODULE$.httpDateFormat(value));
    }

    public Option<String> location() {
        return this.headerMap().get("Location");
    }

    public void location_$eq(String value) {
        this.headerMap().set("Location", value);
    }

    public Option<String> mediaType() {
        return this.contentType().flatMap((Function1 & Serializable & scala.Serializable)contentType -> {
            String string;
            int n = contentType.indexOf(";");
            switch (n) {
                case -1: {
                    string = contentType;
                    break;
                }
                default: {
                    string = contentType.substring(0, n);
                    break;
                }
            }
            String beforeSemi = string;
            String mediaType = beforeSemi.trim();
            return new StringOps(Predef$.MODULE$.augmentString(mediaType)).nonEmpty() ? new Some((Object)mediaType.toLowerCase()) : None$.MODULE$;
        });
    }

    public void mediaType_$eq(String value) {
        Option<String> option = this.contentType();
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            String contentType = (String)some.value();
            IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';', 2);
            if (parts.length() == 2) {
                this.contentType_$eq(value + ";" + parts.apply(1));
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.contentType_$eq(value);
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            this.contentType_$eq(value);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
    }

    public Option<String> referer() {
        return this.headerMap().get("Referer");
    }

    public void referer_$eq(String value) {
        this.headerMap().set("Referer", value);
    }

    public Option<String> retryAfter() {
        return this.headerMap().get("Retry-After");
    }

    public void retryAfter_$eq(String value) {
        this.headerMap().set("Retry-After", value);
    }

    public void retryAfter_$eq(long value) {
        this.retryAfter_$eq(((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public Option<String> server() {
        return this.headerMap().get("Server");
    }

    public void server_$eq(String value) {
        this.headerMap().set("Server", value);
    }

    public Option<String> userAgent() {
        return this.headerMap().get("User-Agent");
    }

    public void userAgent_$eq(String value) {
        this.headerMap().set("User-Agent", value);
    }

    public Option<String> wwwAuthenticate() {
        return this.headerMap().get("Www-Authenticate");
    }

    public void wwwAuthenticate_$eq(String value) {
        this.headerMap().set("Www-Authenticate", value);
    }

    public Option<String> xForwardedFor() {
        return this.headerMap().get("X-Forwarded-For");
    }

    public void xForwardedFor_$eq(String value) {
        this.headerMap().set("X-Forwarded-For", value);
    }

    public boolean isXmlHttpRequest() {
        return this.headerMap().get("X-Requested-With").exists((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)Message.$anonfun$isXmlHttpRequest$1(x$8)));
    }

    public final int length() {
        return this.content().length();
    }

    public final int getLength() {
        return this.length();
    }

    public String contentString() {
        Charset charset;
        try {
            charset = Charset.forName((String)this.charset().getOrElse((Function0 & Serializable & scala.Serializable)() -> "UTF-8"));
        }
        catch (Throwable throwable) {
            charset = Message$.MODULE$.Utf8();
        }
        Charset encoding = charset;
        return Buf$.MODULE$.decodeString(this.content(), encoding);
    }

    public String getContentString() {
        return this.contentString();
    }

    public void contentString_$eq(String value) {
        String string = value;
        String string2 = "";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            this.clearContent();
        } else {
            this.content_$eq(Buf.Utf8$.MODULE$.apply(value));
        }
    }

    public final void setContentString(String value) {
        this.contentString_$eq(value);
    }

    public <T> T withInputStream(Function1<InputStream, T> f) {
        Object object;
        try (InputStream inputStream = this.getInputStream();){
            object = f.apply((Object)inputStream);
        }
        return (T)object;
    }

    public final InputStream getInputStream() {
        return new BufInputStream(this.content());
    }

    public final <T> T withReader(Function1<Reader, T> f) {
        return this.withInputStream((Function1 & Serializable & scala.Serializable)inputStream -> {
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream);
            return f.apply((Object)reader);
        });
    }

    public final Reader getReader() {
        return new InputStreamReader(this.getInputStream());
    }

    public final void write(String string) throws IllegalStateException {
        this.write(Buf.Utf8$.MODULE$.apply(string));
    }

    public final void write(Buf buf) throws IllegalStateException {
        if (this.isChunked()) {
            throw new IllegalStateException("Cannot write buffers to a chunked message!");
        }
        this.content_$eq(this.content().concat(buf));
    }

    public final void write(byte[] bytes) throws IllegalStateException {
        this.write(Buf.ByteArray$.Shared$.MODULE$.apply(bytes));
    }

    /*
     * WARNING - void declaration
     */
    public final <T> T withOutputStream(Function1<OutputStream, T> f) throws IllegalStateException {
        void v0;
        try (BufOutputStream outputStream = new BufOutputStream(1024);){
            void var3_3;
            Object result = f.apply((Object)outputStream);
            this.write(outputStream.contentsAsBuf());
            v0 = var3_3;
        }
        return v0;
    }

    public final <T> T withWriter(Function1<Writer, T> f) throws IllegalStateException {
        return this.withOutputStream((Function1 & Serializable & scala.Serializable)outputStream -> {
            Object object;
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)outputStream, Message$.MODULE$.Utf8());){
                object = f.apply((Object)writer);
            }
            return object;
        });
    }

    public final void clearContent() {
        this.content_$eq(Buf$.MODULE$.Empty());
    }

    public Future<BoxedUnit> close() {
        return ((Closable)this.writer()).close();
    }

    public final Message keepAlive(boolean keepAlive) {
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http10();
        Version version3 = version;
        Object object = !(version2 != null ? !((Object)version2).equals(version3) : version3 != null) ? (keepAlive ? this.headerMap().set("Connection", "keep-alive") : this.headerMap().remove("Connection")) : (keepAlive ? this.headerMap().remove("Connection") : this.headerMap().set("Connection", "close"));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean keepAlive() {
        String value;
        boolean bl = false;
        Some some = null;
        Option<String> option = this.headerMap().get("Connection");
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            String value2 = (String)some.value();
            if (value2.equalsIgnoreCase("close")) {
                return false;
            }
        }
        if (bl && (value = (String)some.value()).equalsIgnoreCase("keep-alive")) {
            return true;
        }
        Version version = this.version();
        Version version2 = Version$.MODULE$.Http11();
        if (version != null) {
            if (!((Object)version).equals(version2)) return false;
            return true;
        }
        if (version2 == null) return true;
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$accept$2(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$acceptMediaTypes$3(String x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$charset$1(Object nonLocalReturnKey1$1, String contentType) {
        IndexedSeq<String> parts = StringUtil$.MODULE$.split(contentType, ';');
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), parts.length() - 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            String part = ((String)parts.apply(i)).trim();
            if (part.startsWith("charset=")) {
                int equalsIndex = part.indexOf(61);
                String charset = part.substring(equalsIndex + 1);
                throw new NonLocalReturnControl(nonLocalReturnKey1$1, (Object)new Some((Object)charset));
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$charset_$eq$2(String x$6) {
        return x$6.trim().startsWith("charset=");
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$3(IndexedSeq parts$2, StringBuilder builder$1, int i) {
        builder$1.append(";");
        return builder$1.append((String)parts$2.apply(i));
    }

    public static final /* synthetic */ StringBuilder $anonfun$charset_$eq$4(String value$1, IndexedSeq parts$2, StringBuilder builder$1, int i) {
        StringBuilder stringBuilder;
        String part = (String)parts$2.apply(i);
        if (part.trim().startsWith("charset=")) {
            builder$1.append(";charset=");
            stringBuilder = builder$1.append(value$1);
        } else {
            builder$1.append(";");
            stringBuilder = builder$1.append(part);
        }
        return stringBuilder;
    }

    public static final /* synthetic */ long $anonfun$contentLength$1(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).toLong();
    }

    public static final /* synthetic */ boolean $anonfun$isXmlHttpRequest$1(String x$8) {
        return x$8.toLowerCase().contains("xmlhttprequest");
    }

    public static final class BufOutputStream
    extends ByteArrayOutputStream {
        public Buf contentsAsBuf() {
            return Buf.ByteArray$.Owned$.MODULE$.apply(this.buf, 0, this.count);
        }

        public BufOutputStream(int initialSize) {
            super(initialSize);
        }
    }
}

