/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAddNewAgrSyncRspBO;
import com.tydic.dyc.agr.service.agr.bo.AgrAppScopeBO;
import com.tydic.dyc.agr.service.agr.bo.AgrMainBO;
import com.tydic.dyc.agr.service.agr.bo.AgrPayConfigBO;
import com.tydic.dyc.agr.utils.IdUtil;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class AgrAddNewAgrSyncServiceImpl
implements AgrAddNewAgrSyncService {
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;

    public AgrAddNewAgrSyncRspBO addNewAgrSync(AgrAddNewAgrSyncReqBO agrAddNewAgrSyncReqBO) {
        AgrAddNewAgrSyncRspBO rspBO = new AgrAddNewAgrSyncRspBO();
        Integer syncNum = this.agrLogModel.checkSyncStatus(agrAddNewAgrSyncReqBO.getAgrId(), agrAddNewAgrSyncReqBO.getBatchUniqueId());
        if (syncNum.equals(agrAddNewAgrSyncReqBO.getTotalBatchCount())) {
            throw new ZTBusinessException("\u540c\u6b65\u5b8c\u6210");
        }
        Long agrId = IdUtil.nextId();
        rspBO.setAgrId(agrId);
        BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
        bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
        bkAgrBigDataLogDo.setBatchUniqueId(agrAddNewAgrSyncReqBO.getBatchUniqueId());
        bkAgrBigDataLogDo.setTotalBatchCount(agrAddNewAgrSyncReqBO.getTotalBatchCount());
        bkAgrBigDataLogDo.setNowBatchCount(agrAddNewAgrSyncReqBO.getNowBatchCount());
        bkAgrBigDataLogDo.setAgrId(agrId + "");
        bkAgrBigDataLogDo.setAgrCode(agrAddNewAgrSyncReqBO.getAgrAgrMainBO().getAgrCode());
        bkAgrBigDataLogDo.setContractCode(bkAgrBigDataLogDo.getContractCode());
        bkAgrBigDataLogDo.setDealStatus("2");
        bkAgrBigDataLogDo.setBatchOperType(1);
        bkAgrBigDataLogDo.setIsCopyMain(agrAddNewAgrSyncReqBO.getSyncType() == 1 ? 1 : 0);
        bkAgrBigDataLogDo.setCreateName(new Date().toString());
        this.agrLogModel.addLog(bkAgrBigDataLogDo);
        this.addData(agrAddNewAgrSyncReqBO, agrId);
        if (syncNum + 1 == agrAddNewAgrSyncReqBO.getTotalBatchCount()) {
            rspBO.setSyncFinishFlag(Integer.valueOf(1));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void addData(AgrAddNewAgrSyncReqBO syncReqBO, Long agrId) {
        if (syncReqBO.getSyncType() == 2) {
            AgrMainBO agrAgrMainBO = syncReqBO.getAgrAgrMainBO();
            agrAgrMainBO.setAgrId(agrAgrMainBO.getAgrId());
            this.agrModel.insertAgrMain(agrAgrMainBO);
            AgrAppScopeBO agrAppScopeBO = syncReqBO.getAgrAppScopeBO();
            agrAppScopeBO.setAgrId(agrId);
            agrAppScopeBO.setAppScopeId(Long.valueOf(IdUtil.nextId()));
            this.agrModel.insertAgrAppScope(syncReqBO.getAgrAppScopeBO());
            AgrPayConfigBO agrPayConfigBO = syncReqBO.getAgrPayConfigBO();
            agrPayConfigBO.setAgrId(agrId);
            agrPayConfigBO.setPayCfgId(Long.valueOf(IdUtil.nextId()));
            this.agrModel.insertAgrPayConfig(syncReqBO.getAgrPayConfigBO());
        }
        List bos = syncReqBO.getAgrMateriaPriceItemBOs();
        bos.forEach(obj -> {
            obj.setAgrId(agrId);
            obj.setAgrMateriaPriceItemId(Long.valueOf(IdUtil.nextId()));
        });
        this.agrModel.insertMateriaPriceItemList(bos);
    }

    public AgrModel getAgrModel() {
        return this.agrModel;
    }

    public AgrLogModel getAgrLogModel() {
        return this.agrLogModel;
    }

    public AgrChangeModel getAgrChangeModel() {
        return this.agrChangeModel;
    }

    public void setAgrModel(AgrModel agrModel) {
        this.agrModel = agrModel;
    }

    public void setAgrLogModel(AgrLogModel agrLogModel) {
        this.agrLogModel = agrLogModel;
    }

    public void setAgrChangeModel(AgrChangeModel agrChangeModel) {
        this.agrChangeModel = agrChangeModel;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgrAddNewAgrSyncServiceImpl)) {
            return false;
        }
        AgrAddNewAgrSyncServiceImpl other = (AgrAddNewAgrSyncServiceImpl)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AgrModel this$agrModel = this.getAgrModel();
        AgrModel other$agrModel = other.getAgrModel();
        if (this$agrModel == null ? other$agrModel != null : !this$agrModel.equals(other$agrModel)) {
            return false;
        }
        AgrLogModel this$agrLogModel = this.getAgrLogModel();
        AgrLogModel other$agrLogModel = other.getAgrLogModel();
        if (this$agrLogModel == null ? other$agrLogModel != null : !this$agrLogModel.equals(other$agrLogModel)) {
            return false;
        }
        AgrChangeModel this$agrChangeModel = this.getAgrChangeModel();
        AgrChangeModel other$agrChangeModel = other.getAgrChangeModel();
        return !(this$agrChangeModel == null ? other$agrChangeModel != null : !this$agrChangeModel.equals(other$agrChangeModel));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgrAddNewAgrSyncServiceImpl;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AgrModel $agrModel = this.getAgrModel();
        result = result * 59 + ($agrModel == null ? 43 : $agrModel.hashCode());
        AgrLogModel $agrLogModel = this.getAgrLogModel();
        result = result * 59 + ($agrLogModel == null ? 43 : $agrLogModel.hashCode());
        AgrChangeModel $agrChangeModel = this.getAgrChangeModel();
        result = result * 59 + ($agrChangeModel == null ? 43 : $agrChangeModel.hashCode());
        return result;
    }

    public String toString() {
        return "AgrAddNewAgrSyncServiceImpl(agrModel=" + this.getAgrModel() + ", agrLogModel=" + this.getAgrLogModel() + ", agrChangeModel=" + this.getAgrChangeModel() + ")";
    }
}

