package com.tydic.dyc.agr.model.common;


import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import java.util.List;

public interface IUocCommonModel {
    /**
     * 保存待办信息
     * @param uocTodo
     * @return
     */
    int saveTodoInfo(UocTodo uocTodo);

    /**
     * 根据主键id更新待办信息
     * @param uocTodo
     * @return
     */
    int updateTodoById(UocTodo uocTodo);

    /**
     * 查询单条待办信息
     * @param uocTodo
     * @return
     */
    UocTodo getTodoInfo(UocTodo uocTodo);

    /**
     * 查询多条待办信息
     * @param uocTodo
     * @return
     */
    List<UocTodo> getTodoListInfo(UocTodo uocTodo);

    /**
     * 批量插入待办信息
     * @param list
     */
    void insertBatchTodo(List<UocTodo> list);
    /**
     * 审批单新增方法
     */
    void createAuditOrder(AgrCommonOrderDo param0);
}
