package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.service.agr.AgrCancelAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrCancelAgrSyncRspBO;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.constants.AgrConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@HTServiceImpl
public class AgrCancelAgrSyncServiceImpl implements AgrCancelAgrSyncService {
    @Autowired
    private AgrModel agrModel;

    @Override
    public AgrCancelAgrSyncRspBO cancelAgrSync(AgrCancelAgrSyncReqBO reqBO) {
        //更新协议状态为已失效，
        BkAgrMainDo bkAgrMainDo = new BkAgrMainDo();
        bkAgrMainDo.setAgrId(reqBO.getAgrId());
        bkAgrMainDo.setAgrCode(reqBO.getAgrCode());
        bkAgrMainDo.setContractCode(reqBO.getContractCode());
        bkAgrMainDo.setAgrStatus(AgrConstant.APPROVE_STATUS.EXPIRED);
        agrModel.updateBy(bkAgrMainDo);
        //同步es todo 修改协议明细、协议es的状态

        AgrCancelAgrSyncRspBO rspBO = new AgrCancelAgrSyncRspBO();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
