/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrQryAgrMateriaPriceItemListService;
import com.tydic.dyc.agr.service.agr.bo.AgrMateriaPriceItemBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceReqBO;
import com.tydic.dyc.agr.service.agr.bo.AgrQryAgrMateriaPriceItemListServiceRspBO;
import com.tydic.dyc.constants.AgrConstant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.agr.service.agr.AgrQryAgrMateriaPriceItemListService"})
public class AgrQryAgrMateriaPriceItemListServiceImpl
implements AgrQryAgrMateriaPriceItemListService {
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Autowired
    private AgrModel agrModel;

    @PostMapping(value={"qryAgrMateriaPriceItemList"})
    public AgrQryAgrMateriaPriceItemListServiceRspBO qryAgrMateriaPriceItemList(@RequestBody AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        BkAgrMainDo agrMainDo = new BkAgrMainDo();
        agrMainDo.setAgrId(reqBO.getAgrId());
        BkAgrMainDo agrMainBO = this.agrModel.qryMain(agrMainDo);
        AgrQryAgrMateriaPriceItemListServiceRspBO rspBO = new AgrQryAgrMateriaPriceItemListServiceRspBO();
        rspBO = StringUtils.isEmpty((Object)reqBO.getAgrMainHisId()) ? this.agrMateriaPriceModel.qryMateriaPriceItem(reqBO) : this.agrMateriaPriceModel.qryMateriaPriceItemHis(reqBO);
        if (AgrConstant.IsAutarky.YES == agrMainBO.getIsAutarky()) {
            rspBO.setRows(this.converParam(rspBO, reqBO));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<AgrMateriaPriceItemBO> converParam(AgrQryAgrMateriaPriceItemListServiceRspBO rspBO, AgrQryAgrMateriaPriceItemListServiceReqBO reqBO) {
        List rows = rspBO.getRows();
        if (CollectionUtils.isEmpty((Collection)rows)) {
            List<AgrMateriaPriceItemBO> collect = rows.stream().filter(obj -> obj.getPriceType() != 4).collect(Collectors.toList());
            List<Object> agrMateriaPriceItemBOS = new ArrayList();
            agrMateriaPriceItemBOS = StringUtils.isEmpty((Object)reqBO.getAgrMainHisId()) ? this.agrMateriaPriceModel.qrySelfSalePrice(collect) : this.agrMateriaPriceModel.qrySelfSalePriceHis(collect);
            HashMap maps = new HashMap();
            if (AgrConstant.PriceType.UNIFIED == reqBO.getPriceType()) {
                agrMateriaPriceItemBOS.forEach(obj -> maps.put(obj.getMaterialCode(), obj));
            }
            if (AgrConstant.PriceType.REGION == reqBO.getPriceType()) {
                agrMateriaPriceItemBOS.forEach(obj -> maps.put(obj.getMaterialCode() + "_" + obj.getProvinceCode() + "_" + obj.getCityCode(), obj));
            }
            if (AgrConstant.PriceType.EXCLUSIVE == reqBO.getPriceType()) {
                agrMateriaPriceItemBOS.forEach(obj -> maps.put(obj.getMaterialCode() + "_" + obj.getExclusiveMainOrgId() + "_", obj));
            }
            rows.forEach(obj -> {
                String str = null;
                if (AgrConstant.PriceType.UNIFIED == reqBO.getPriceType()) {
                    str = obj.getMaterialCode();
                }
                if (AgrConstant.PriceType.REGION == reqBO.getPriceType()) {
                    str = obj.getMaterialCode() + "_" + obj.getProvinceCode() + "_" + obj.getCityCode();
                }
                if (AgrConstant.PriceType.EXCLUSIVE == reqBO.getPriceType()) {
                    str = obj.getMaterialCode() + "_" + obj.getExclusiveMainOrgId();
                }
                AgrMateriaPriceItemBO itemBO = (AgrMateriaPriceItemBO)maps.get(str);
                obj.setSalePrice(itemBO.getSalePrice());
                obj.setSaleUnTaxPrice(itemBO.getUnTaxPrice());
                obj.setAgrSaleMateriaPriceItemId(itemBO.getAgrSaleMateriaPriceItemId());
            });
        }
        return rows;
    }
}

