package com.tydic.dyc.agr.model.log.impl;

import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.repository.AgrLogRepository;
import org.bouncycastle.cms.PasswordRecipientId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 协议日志表
 * @author zhanghengrui
 * @date 2023/1/31 15:29
 */
@Service
public class AgrLogModelImpl implements AgrLogModel {

    @Autowired
    private AgrLogRepository agrLogRepository;

    @Override
    public List<BkAgrChangeBigDataLogDo> qryChangeLogData(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {
        return agrLogRepository.qryChangeLogData(bkAgrChangeBigDataLogDo);
    }

    @Override
    public Integer updateDealStatus(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {
        return agrLogRepository.updateDealStatus(bkAgrChangeBigDataLogDo);
    }

    @Override
    public Integer checkSyncStatus(Long argId, Long batchUniqueId) {
        return agrLogRepository.checkSyncStatus(argId,batchUniqueId);
    }

    @Override
    public Boolean checkSyncFinishFlag() {
        return null;
    }

    @Override
    public Integer addLog(BkAgrBigDataLogDo bkAgrBigDataLogDo) {
        return agrLogRepository.addLog(bkAgrBigDataLogDo);
    }


    @Override
    public Integer addChangeLog(BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo) {
        return agrLogRepository.addChangeLog(bkAgrChangeBigDataLogDo);
    }


}
