package com.tydic.dyc.agr.service;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrBigDataLogDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrAddNewAgrSyncService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.agr.utils.IdUtil;
import com.tydic.dyc.base.constants.BaseRspConstant;
import com.tydic.dyc.util.CommonUtil;
import lombok.Data;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author yinletian
 * @date 2023/1/31
 */
@Slf4j
@HTServiceImpl
public class AgrAddNewAgrSyncServiceImpl implements AgrAddNewAgrSyncService {
    @Autowired
    private AgrModel agrModel;
    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Override
    public AgrAddNewAgrSyncRspBO addNewAgrSync(AgrAddNewAgrSyncReqBO agrAddNewAgrSyncReqBO) {
        AgrAddNewAgrSyncRspBO rspBO = new AgrAddNewAgrSyncRspBO();

        // 校验是否同步完成
        Integer syncNum = agrLogModel.checkSyncStatus(agrAddNewAgrSyncReqBO.getAgrId(), agrAddNewAgrSyncReqBO.getBatchUniqueId());

        if (syncNum.equals(agrAddNewAgrSyncReqBO.getTotalBatchCount())) throw new ZTBusinessException("同步完成");

        //Long agrId =agrAddNewAgrSyncReqBO.getAgrId();
        Long agrId =IdUtil.nextId();
        rspBO.setAgrId(agrId);
        // 日志表增加数据
        BkAgrBigDataLogDo bkAgrBigDataLogDo = new BkAgrBigDataLogDo();
        bkAgrBigDataLogDo.setAgrBigDataLogId(IdUtil.nextId());
        bkAgrBigDataLogDo.setBatchUniqueId(agrAddNewAgrSyncReqBO.getBatchUniqueId());
        bkAgrBigDataLogDo.setTotalBatchCount(agrAddNewAgrSyncReqBO.getTotalBatchCount());
        bkAgrBigDataLogDo.setNowBatchCount(agrAddNewAgrSyncReqBO.getNowBatchCount());
        bkAgrBigDataLogDo.setAgrId(agrId+"");
        bkAgrBigDataLogDo.setAgrCode(agrAddNewAgrSyncReqBO.getSyncType()==2?agrAddNewAgrSyncReqBO.getAgrAgrMainBO().getAgrCode():"");
        bkAgrBigDataLogDo.setContractCode(agrAddNewAgrSyncReqBO.getSyncType()==2?agrAddNewAgrSyncReqBO.getAgrAgrMainBO().getContractCode():"");
        // 处理完成
        bkAgrBigDataLogDo.setDealStatus("2");
        bkAgrBigDataLogDo.setBatchOperType(1);
        // 是否添加了主体
        bkAgrBigDataLogDo.setIsCopyMain(agrAddNewAgrSyncReqBO.getSyncType() == 1?1:0);
        bkAgrBigDataLogDo.setCreateName(new Date().toString());
        agrLogModel.addLog(bkAgrBigDataLogDo);

        //新增数据
        addData(agrAddNewAgrSyncReqBO,agrId);

        // 如果批次推送完成
        if (syncNum+1==agrAddNewAgrSyncReqBO.getTotalBatchCount()){
            rspBO.setSyncFinishFlag(1);
            // 同步es
            log.info("同步es");
            rspBO.setPickerConfigNo("1");
            //List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS = agrMateriaPriceModel.qryMateriaPriceItem(agrId);
            //log.info("es同步日志："+ JSON.toJSONString(agrMateriaPriceItemBOS));
            //List<Long> collect = agrMateriaPriceItemBOS.stream().map(AgrMateriaPriceItemBO::getAgrMateriaPriceItemId).collect(Collectors.toList());
            //List<Map<String,Long>> maps = new ArrayList<>();
            //Map map = new HashMap();
            //collect.forEach(obj->{
            //    map.put("agrMateriaPriceItemId",obj);
            //    maps.add(map);
            //});
            //List<AgrPriceItemSyncBo> jsl = AgrRu.jsl(agrMateriaPriceItemBOS, AgrPriceItemSyncBo.class);
            //log.info("es日志"+JSON.toJSONString(jsl));
            //rspBO.setTraceList(jsl);
        }

        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }

    private void addData(AgrAddNewAgrSyncReqBO syncReqBO,Long agrId){
        //明细加其他全量信息同步
        if(syncReqBO.getSyncType() == 2){
            AgrMainBO agrAgrMainBO = syncReqBO.getAgrAgrMainBO();
            agrAgrMainBO.setAgrId(agrId);
            agrModel.insertAgrMain(agrAgrMainBO);

            List<AgrAppScopeBO> agrAppScopeBO = syncReqBO.getAgrAppScopeBO();
            agrAppScopeBO.forEach(obj->{
                obj.setAgrId(agrId);
                obj.setAppScopeId(IdUtil.nextId());
            });
            agrModel.inserttAgrAppScopeBatch(agrAppScopeBO);

            AgrPayConfigBO agrPayConfigBO = syncReqBO.getAgrPayConfigBO();
            agrPayConfigBO.setAgrId(agrId);
            agrPayConfigBO.setPayCfgId(IdUtil.nextId());
            agrModel.insertAgrPayConfig(syncReqBO.getAgrPayConfigBO());
        }
        List<AgrMateriaPriceItemBO> bos = syncReqBO.getAgrMateriaPriceItemBOs();
        bos.forEach(obj->{
            obj.setAgrId(agrId);
            obj.setAgrMateriaPriceItemId(IdUtil.nextId());
            obj.setKeyCode(CommonUtil.getKeyCode(obj));
        });
        agrModel.insertMateriaPriceItemList(bos);
    }
}
