package com.tydic.dyc.agr.service;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.agr.model.procinst.sub.UocTodo;
import com.tydic.dyc.agr.model.common.IUocCommonModel;
import com.tydic.dyc.agr.service.agr.AgrBatchSaveTodoInfoService;
import com.tydic.dyc.agr.service.agr.bo.AgrBatchSaveTodoInfoReqBo;
import com.tydic.dyc.agr.service.agr.bo.AgrBatchSaveTodoInfoRspBo;
import com.tydic.dyc.agr.service.agr.bo.AgrTodoBo;
import com.tydic.dyc.agr.utils.AgrRu;
import com.tydic.dyc.base.constants.BaseRspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import java.util.List;

/**
 * 描述: 〈领域服务-批量保存待办数据 实现〉
 * @author : 王久鑫
 * @date : 2022/10/27 14:05
 */
@Slf4j
@HTServiceImpl
public class AgrBatchSaveTodoInfoServiceImpl implements AgrBatchSaveTodoInfoService {
    @Autowired
    private IUocCommonModel uocCommonModel;
    @Override
    public AgrBatchSaveTodoInfoRspBo batchSaveTodoInfo(AgrBatchSaveTodoInfoReqBo uocBatchSaveTodoInfoReqBo) {
        log.info("批量保存待办数据入参");
        validateArgs(uocBatchSaveTodoInfoReqBo);
        List<UocTodo> jsl = AgrRu.jsl(uocBatchSaveTodoInfoReqBo.getUocTodoBos(), UocTodo.class);
        uocCommonModel.insertBatchTodo(jsl);
        AgrBatchSaveTodoInfoRspBo rspBO = new AgrBatchSaveTodoInfoRspBo();
        rspBO.setRespCode(BaseRspConstant.RSP_CODE_SUCCESS);
        rspBO.setRespDesc(BaseRspConstant.RSP_DESC_SUCCESS);
        log.info("批量保存待办数据出参");
        return rspBO;
    }
    private void validateArgs(AgrBatchSaveTodoInfoReqBo uocBatchSaveTodoInfoReqBo){
        if (null == uocBatchSaveTodoInfoReqBo) {
            throw new ZTBusinessException("入参对象不能为空");
        }
        if (null == uocBatchSaveTodoInfoReqBo.getUocTodoBos()) {
            throw new ZTBusinessException("入参待办信息列表不能为空");
        }
        for (AgrTodoBo uocTodo : uocBatchSaveTodoInfoReqBo.getUocTodoBos()) {
            if (null == uocTodo.getTodoId()) {
                throw new ZTBusinessException("入参待办ID不能为空");
            }
            if (null == uocTodo.getOrderId()) {
                throw new ZTBusinessException("入参订单ID不能为空");
            }
            if (null == uocTodo.getBusiId()) {
                throw new ZTBusinessException("入参业务ID不能为空");
            }
        }
    }
}
