package com.tydic.dyc.agr.service;

import com.tydic.dyc.agr.model.agr.AgrModel;
import com.tydic.dyc.agr.model.agr.BkAgrMainDo;
import com.tydic.dyc.agr.model.change.AgrChangeModel;
import com.tydic.dyc.agr.model.change.BkAgrBigChangeItemDataWhileDo;
import com.tydic.dyc.agr.model.his.AgrHisModel;
import com.tydic.dyc.agr.model.log.AgrLogModel;
import com.tydic.dyc.agr.model.log.BkAgrChangeBigDataLogDo;
import com.tydic.dyc.agr.model.materiaPrice.AgrMateriaPriceModel;
import com.tydic.dyc.agr.service.agr.AgrChangeCronJobService;
import com.tydic.dyc.agr.service.agr.bo.*;
import com.tydic.dyc.agr.utils.IdUtil;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 定时任务
 * @author zhanghengrui
 * @date 2023/1/31 15:14
 */
@Service
public class AgrChangeCronJobServiceImpl implements AgrChangeCronJobService {

    @Autowired
    private AgrLogModel agrLogModel;
    @Autowired
    private AgrChangeModel agrChangeModel;
    @Autowired
    private AgrHisModel agrHisModel;
    @Autowired
    private AgrMateriaPriceModel agrMateriaPriceModel;
    @Autowired
    private AgrModel agrModel;


    @Override
    public AgrChangeCronJobRspBO changeConJob(AgrChangeCronJobReqBO agrChangeCronJobReqBO) {

        AgrChangeCronJobRspBO agrChangeCronJobRspBO = new AgrChangeCronJobRspBO();

        // 1.查询变更批量数据处理日志表，得到需要处理的数据
        BkAgrChangeBigDataLogDo qryLogDo = new BkAgrChangeBigDataLogDo();
        qryLogDo.setDealStatus("1");
        List<BkAgrChangeBigDataLogDo> bkAgrChangeBigDataLogDo = agrLogModel.qryChangeLogData(qryLogDo);

        // 2.根据变更日志表中记录转移数据:取其中一条
        BkAgrChangeBigDataLogDo bkAgrChangeBigDataLogDo1 = bkAgrChangeBigDataLogDo.get(0);

        // 2.0 先把状态置为处理中，防止重复消费
        BkAgrChangeBigDataLogDo updateLogDo_1 = new BkAgrChangeBigDataLogDo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo1,updateLogDo_1);
        updateLogDo_1.setDealStatus("2");
        agrLogModel.updateDealStatus(updateLogDo_1);

        // 查询协议主体
        BkAgrMainDo qryMain = new BkAgrMainDo();
        qryMain.setAgrId(bkAgrChangeBigDataLogDo1.getAgrId());
        BkAgrMainDo bkAgrMainDo = agrModel.qryMain(qryMain);
        agrChangeCronJobRspBO.setAgrId(bkAgrMainDo.getAgrId());

        // 如果是价格库采购价变更
        if (bkAgrChangeBigDataLogDo1.getBatchOperType()==3) {
            // 2.1 根据协议id转移协议数据到历史表
            agrHisModel.transDataFromMain2His(bkAgrChangeBigDataLogDo1.getAgrId(),new ArrayList<>());

            // 2.2 根据批次得到变更临时表中的数据转移到主表
            agrChangeModel.transDataFromChangeTemp2Main(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId(),new ArrayList<>());
        }
        // 如果是价格库销售价变更
        else if (bkAgrChangeBigDataLogDo1.getBatchOperType()==4){
            agrChangeModel.addDataFromChangeTemp2Material(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId());
        }
        // 如果是合同新增
        else if (bkAgrChangeBigDataLogDo1.getBatchOperType()==1){
            AgrMateriaPriceItemBO addBo = new AgrMateriaPriceItemBO();
            List<AgrMateriaPriceItemBO> list = new ArrayList<>();
            addBo.setAgrId(bkAgrChangeBigDataLogDo1.getAgrId());
            list.add(addBo);
            List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS = agrMateriaPriceModel.qrySelfSalePrice(list);

            agrChangeCronJobRspBO.setAgrUccAutoAgrPriceBO(makeData2Ucc(agrMateriaPriceItemBOS,qryMain));
        }
        // 如果是合同变更
        else {
            // 2.0 查出变更了的明细
            List<BkAgrBigChangeItemDataWhileDo> bkWhileDos = agrChangeModel.qryChangeMaterial(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId());

            // 2.1 根据协议id转移协议数据到历史表
            agrHisModel.transDataFromMain2His(bkAgrChangeBigDataLogDo1.getAgrId(),bkWhileDos);

            // 2.2 根据批次得到变更临时表中的数据转移到主表
            agrChangeModel.transDataFromChangeTemp2Main(bkAgrChangeBigDataLogDo1.getAgrId(), bkAgrChangeBigDataLogDo1.getBatchUniqueId(),bkWhileDos);

            // 2.3
            makeChangeData2Ucc(bkWhileDos,qryMain);

            agrChangeCronJobRspBO.setType(2);
            agrChangeCronJobRspBO.setAgrStatus(bkAgrMainDo.getAgrStatus());
        }


        // 2.3 处理状态置为失败或者成功
        BkAgrChangeBigDataLogDo updateLogDo_2 = new BkAgrChangeBigDataLogDo();
        BeanUtils.copyProperties(bkAgrChangeBigDataLogDo1,updateLogDo_2);
        updateLogDo_2.setDealStatus("3");
        agrLogModel.updateDealStatus(updateLogDo_2);

        // 同步es

        if(bkAgrChangeBigDataLogDo1.getBatchOperType()!=1) agrChangeCronJobRspBO.setAgrCode(bkAgrChangeBigDataLogDo1.getAgrCode());

        return agrChangeCronJobRspBO;
    }

    private AgrUccAutoAgrPriceBO makeData2Ucc(List<AgrMateriaPriceItemBO> agrMateriaPriceItemBOS,BkAgrMainDo bkAgrMainDo){

        AgrUccAutoAgrPriceBO agrUccAutoAgrPriceBO = new AgrUccAutoAgrPriceBO();

        BeanUtils.copyProperties(bkAgrMainDo,agrUccAutoAgrPriceBO);
        // 新增
        agrUccAutoAgrPriceBO.setOperType(1);
        agrUccAutoAgrPriceBO.setBatchUniqueId(IdUtil.nextId());

        List<BkAgrPriceBo> list = new ArrayList<>();

        for (AgrMateriaPriceItemBO agrMateriaPriceItemBO : agrMateriaPriceItemBOS) {
            BkAgrPriceBo bkAgrPriceBo = new BkAgrPriceBo();
            BeanUtils.copyProperties(agrMateriaPriceItemBO,bkAgrPriceBo);
            bkAgrPriceBo.setOperItemType(1);
            bkAgrPriceBo.setProvince(Integer.valueOf(agrMateriaPriceItemBO.getProvinceCode()));
            bkAgrPriceBo.setCity(Integer.valueOf(agrMateriaPriceItemBO.getCityCode()));
            bkAgrPriceBo.setOrgId(agrMateriaPriceItemBO.getExclusiveOrgId());
            bkAgrPriceBo.setOrgName(agrMateriaPriceItemBO.getExclusiveOrgName());
            bkAgrPriceBo.setStart(agrMateriaPriceItemBO.getStartNum());
            bkAgrPriceBo.setEnd(agrMateriaPriceItemBO.getStopNum());
            bkAgrPriceBo.setPrice(agrMateriaPriceItemBO.getPrice());
            bkAgrPriceBo.setRate(agrMateriaPriceItemBO.getTaxRate());

            list.add(bkAgrPriceBo);
        }

        agrUccAutoAgrPriceBO.setAgrPriceList(list);

        return agrUccAutoAgrPriceBO;
    }

    private AgrUccAutoAgrPriceBO makeChangeData2Ucc(List<BkAgrBigChangeItemDataWhileDo> bkWhileDos,BkAgrMainDo bkAgrMainDo){

        AgrUccAutoAgrPriceBO agrUccAutoAgrPriceBO = new AgrUccAutoAgrPriceBO();

        BeanUtils.copyProperties(bkAgrMainDo,agrUccAutoAgrPriceBO);
        // 新增
        agrUccAutoAgrPriceBO.setOperType(2);
        agrUccAutoAgrPriceBO.setBatchUniqueId(bkWhileDos.get(0).getBatchUniqueId());

        List<BkAgrPriceBo> list = new ArrayList<>();

        for (BkAgrBigChangeItemDataWhileDo agrMateriaPriceItemBO : bkWhileDos) {
            BkAgrPriceBo bkAgrPriceBo = new BkAgrPriceBo();
            BeanUtils.copyProperties(agrMateriaPriceItemBO,bkAgrPriceBo);
            bkAgrPriceBo.setOperItemType(1);
            bkAgrPriceBo.setProvince(Integer.valueOf(agrMateriaPriceItemBO.getProvinceCode()));
            bkAgrPriceBo.setCity(Integer.valueOf(agrMateriaPriceItemBO.getCityCode()));
            bkAgrPriceBo.setOrgId(agrMateriaPriceItemBO.getExclusiveOrgId());
            bkAgrPriceBo.setOrgName(agrMateriaPriceItemBO.getExclusiveOrgName());
            bkAgrPriceBo.setStart(agrMateriaPriceItemBO.getStartNum());
            bkAgrPriceBo.setEnd(agrMateriaPriceItemBO.getStopNum());
            bkAgrPriceBo.setPrice(agrMateriaPriceItemBO.getPrice());
            bkAgrPriceBo.setRate(agrMateriaPriceItemBO.getTaxRate());

            list.add(bkAgrPriceBo);
        }

        agrUccAutoAgrPriceBO.setAgrPriceList(list);

        return agrUccAutoAgrPriceBO;
    }
}
